/*==============================================================================
**    THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),     **
**              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                 **
**                                                                            **
**  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS   **
**  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR   **
**  WRITTEN AUTHORIZATION OF FEI S.A.S.                                       **
**                                                                            **
**                        RESTRICTED RIGHTS LEGEND                            **
**  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS  **
**  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN  **
**  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT  **
**  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN  **
**  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         **
**                                                                            **
**                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                    **
**                              BORDEAUX, FRANCE                              **
**                            ALL RIGHTS RESERVED                             **
==============================================================================*/

#pragma once

#include <Inventor/nodes/SoNode.h>
#include <Inventor/fields/SoSFColor.h>
#include <Inventor/fields/SoSFFloat.h>

namespace inventor {
namespace node {

class SoRenderTargetTexture;
class SoInternalOutlineEffect;

} // namespace node
} // namespace inventor


/**
 * @PREVIEWTAG
 * 
 * @ingroup nodes
 * 
 * @DESCRIPTION
 *  Apply an outline effect (the suggestive contours of shapes) to the entire scene, without considering shapes present in the SoAnnotation nodes. 
 *  All opaque objects are compatible with the different transparency modes.
 *  For semi-transparent objects, SoOutlineEffect only supports the NO_SORT transparency mode.
 *
 *  Adjustable fields include the #color, #thickness, and #sensitivity of the outline, 
 *  with default values respectively set to black (0.f, 0.f, 0.f), 0.0f, and 0.0f.
 * 
 * @PREVIEWFEATURES
 * 
 * @FILE_FORMAT_DEFAULT
 *   OutlineEffect {
 *    @TABLE_FILE_FORMAT
 *       @TR color        @TD 0.0 0.0 0.0
 *       @TR thickness    @TD 0.0
 *       @TR sensitivity  @TD 0.0
 *    @TABLE_END
 *   }
 *
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *      In addition to the standard rendering, draw the contours of scene objects
 *      in screen space (excluding objects in SoAnnotation nodes).
 *
 * @SEE_ALSO
 *    SoHaloHighlightRenderAction,
 *    SoLineHighlightRenderAction,
 *    SoColorHighlightRenderAction,
 *    SoBoxHighlightRenderAction,
 *    SoHighlightRenderAction,
 *    SoGLRenderAction,
 * 
 * @NODE_SINCE_OIV 2025.2
*/

class INVENTOR_API SoOutlineEffect : public SoNode
{
  SO_NODE_HEADER( SoOutlineEffect );

public:

  /**
   * The color of the outline.
   * Default is black (0.0f, 0.0f, 0.0f).
  */
  SoSFColor color;

  /**
   * Specifies the thickness of the contours.
   * A higher value makes the outlines thicker, while a lower value makes them thinner.
   * The value ranges from 0.0f to 1.0f.
   * Default is 0.0f.
  */
  SoSFFloat thickness;

  /**
   * Specifies the sensitivity to detect contours.
   * A higher value allows for the detection of fine details, 
   * while a lower value only highlights marked variations.
   * The value ranges from 0.0f to 1.0f.
   * Default is 0.0f.
  */
  SoSFFloat sensitivity;

  SoOutlineEffect();

SoEXTENDER public: 
  void doAction( SoAction* action );
  void callback( SoCallbackAction* action );
  void GLRender( SoGLRenderAction* action );
  void getBoundingBox( SoGetBoundingBoxAction* action );
  void getMatrix( SoGetMatrixAction* action );
  void handleEvent( SoHandleEventAction* action );
  void pick( SoPickAction* action );
  void search( SoSearchAction* action );
  void getPrimitiveCount( SoGetPrimitiveCountAction* action );

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  SoChildList* getChildren() const; 
  bool isDefault() const;

protected:
  ~SoOutlineEffect();

private:
  inventor::node::SoInternalOutlineEffect* m_internalOutline;
};
