/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Ronen Barzel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_PENDULUM_
#define  _SO_PENDULUM_

#include <Inventor/nodes/SoRotation.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFBool.h>

#include <Inventor/sensors/SoOneShotSensor.h>
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/engines/SoCalculator.h>
#include <Inventor/engines/SoInterpolate.h>
#include <Inventor/sensors/SoFieldSensor.h>


//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoPendulum
//
//  SoRotation node oscillates between two rotations
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Animated oscillating rotation node.
 * 
 * @ingroup TransformNodes
 * 
 * @DESCRIPTION
 *   The SoPendulum class is derived from SoRotation, so it applies a rotation to the
 *   current transformation. Using engines connected to the @B realTime @b global
 *   field, the rotation value is animated over time between two fixed rotations,
 *   achieving the effect of a swinging pendulum. The period of the swing can be
 *   adjusted by changing the #speed field. The current rotation at any time is
 *   available in the @B rotation @b field, inherited from SoRotation
 * 
 * @FILE_FORMAT_DEFAULT
 *    Pendulum {
 *    @TABLE_FILE_FORMAT
 *       @TR rotation    @TD 0 0 1 0
 *       @TR rotation0   @TD 0 0 1 0
 *       @TR rotation1   @TD 0 0 1 0
 *       @TR speed       @TD 1
 *       @TR on          @TD TRUE
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction,  SoGetBoundingBoxAction,  SoRayPickAction @BR
 *        Concatenates interpolated rotation value with the current transformation
 *        matrix.
 * 
 *    SoGetMatrixAction @BR
 *        Returns transformation matrix specified by the interpolated rotation.
 * 
 * 
 * @SEE_ALSO
 *    SoRotor,
 *    SoShuttle
 * 
 * 
 */
class INVENTOR_API SoPendulum : public SoRotation {

  SO_NODE_HEADER(SoPendulum);

 public:
  // Fields
  /**
   * Defines the first of the two fixed rotations that are interpolated to create the
   * pendular motion.
   * 
   */
  SoSFRotation        rotation0;
  /**
   * Defines the second of the two fixed rotations that are interpolated to create the
   * pendular motion.
   * 
   */
  SoSFRotation        rotation1;
  /**
   * Defines the speed of the pendulum, in cycles per second.
   * 
   */
  SoSFFloat           speed;
  /**
   * Allows applications to enable or disable the motion easily.
   * 
   */
  SoSFBool            on;

  /**
   * Creates a pendulum node with default settings.
   */
  SoPendulum();

 SoEXTENDER public:
  // overload write method not to write internal engines
  virtual void        write(class SoWriteAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

  // overload notify method to check for field updates
  virtual void notify(SoNotList *list);

 protected:
  virtual ~SoPendulum();

 private:
  // internal engines to compute the rotation
  class SoElapsedTime         *time;
  class SoCalculator          *calc;
  class SoInterpolateRotation *interp;

  // keep track of internal connection
  class SoEngineOutput        *internalConnection;

  class SoOneShotSensor       *rotationSensor;
  class SoFieldSensor         *rotation0Sensor;
  class SoFieldSensor         *rotation1Sensor;
  class SoFieldSensor         *onSensor;

  static void rotationSensorCB(void *data, class SoSensor *sensor);
  static void onSensorCB(void *data, class SoSensor *sensor);
};

#endif /* _SO_PENDULUM_ */

