/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
 **=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_POINT_LIGHT_
#define  _SO_POINT_LIGHT_

#include <Inventor/fields/SoSFVec3f.h>
#include <Inventor/nodes/SoLight.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoPointLight
//
//  Point light source node. A point light illuminates in all
//  directions from a given point in space.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Node representing a point light source.
 *
 * @ingroup LightNodes
 *
 * @DESCRIPTION
 *   This node defines a point light source at a fixed 3D location. A point source
 *   illuminates equally in all directions; that is, it is omnidirectional.
 *
 *   A light node defines an illumination source that may affect subsequent
 *   shapes in the scene graph, depending on the current lighting model. Light
 *   sources are affected by the current transformation. A light node under an
 *   SoSeparator does not affect any objects outside that separator.  Lights
 *   may be grouped under an SoGroup node and still affect the rest of the
 *   scene graph.  The viewer classes automatically create a directional light,
 *   called the headlight, that is automatically updated to shine in the same
 *   direction the camera is pointed.
 *
 *   You can also use a node kit to create a light; see the reference page for
 *   SoLightKit.
 *
 *   The lighting model can be changed using an SoLightModel node. Effectively
 *   lighting is enabled by default (default model is PER_VERTEX_PHONG), but can
 *   be turned off by setting the lighting model to BASE_COLOR. In this case the
 *   object's diffuse color is used without modification.  This can be useful for
 *   axes and annotations.
 *
 *   An SoEnvironment node can be used to specify additional options related to lighting:
 *   - The ambient light component of the Phong reflection model.
 *   - Light attenuation for SoPointLight and SoSpotLight nodes.
 *   - Ambient occlusion.
 *
 *   When lighting is enabled, the appearance of most geometry depends on the
 *   normal vectors specified (or computed) for the geometry.  See SoShapeHints
 *   for a discussion of normal computation and the concept of "crease angle".
 *   By default lighting is only computed for the "front" face of most geometry
 *   (there are some exceptions like SoOrthoSlice).  Which face is the front
 *   depends on the vertex ordering. Also see SoShapeHints to control vertex
 *   ordering and to enable "two sided" lighting.  Lighting of line geometry is
 *   affected by the tangent values, if any, specified with SoVertexProperty.
 *
 *   The color components specified for lights mean something different than for
 *   materials. For a light, the numbers correspond to a percentage of full
 *   intensity for each color. If the R, G, and B values for a light's color are
 *   all 1.0, the light is the brightest possible white. If the values are 0.5,
 *   the color is still white, but only at half intensity, so it appears gray.
 *   If R=G=1 and B=0 (full red and green with no blue), the light appears yellow.
 *   The intensity can also be modulated using the #intensity field.
 *
 *   For materials, the numbers correspond to the reflected percentages of those
 *   colors. So if R=1, G=0.5, and B=0 for a material, that material reflects all
 *   the incoming red light, half the incoming green, and none of the incoming
 *   blue light. In other words, if an OpenGL light has components (LR, LG, LB),
 *   and a material has corresponding components (MR, MG, MB), then, ignoring all
 *   other reflectivity effects, the light that arrives at the eye is given by
 *   (LR*MR, LG*MG, LB*MB).  As a result, for example, shining a pure blue light
 *   on a pure red cone has no visible effect.
 *
 *   Similarly, if you have two lights that send (R1, G1, B1) and (R2, G2, B2)
 *   to the eye, the components are added, giving (R1+R2, G1+G2, B1+B2). If any
 *   of the sums are greater than 1 (corresponding to a color brighter than the
 *   hardware can display), the component is clamped to 1.
 *
 *   The maximum number of lights depends on the hardware, but at least eight
 *   simultaneous lights are supported.
 *
 * @FILE_FORMAT_DEFAULT
 *    PointLight {
 *    @TABLE_FILE_FORMAT
 *       @TR on                @TD TRUE
 *       @TR intensity         @TD 1
 *       @TR color             @TD 1 1 1
 *       @TR shadowIntensity   @TD 1
 *       @TR location          @TD 0 0 1
 *    @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *        Activates this light (if so specified) during traversal. All shape nodes that
 *        come after this light in the scene graph are illuminated by this light. The
 *        light's location is affected by the current transformation.
 *        Sets: SoLightElement, SoLightIdElement
 *
 * @SEE_ALSO
 *    SoDirectionalLight,
 *    SoSpotLight,
 *    SoLightModel
 *
 *
 */
class INVENTOR_API SoPointLight : public SoLight
{
  SO_NODE_HEADER( SoPointLight );

public:
  /**
   * Location of the source.
   */
  SoSFVec3f location;

  /**
   * Creates a point light source node with default settings.
   */
  SoPointLight();

SoEXTENDER public:
  // Creates a light source during rendering
  virtual void GLRender( SoGLRenderAction* action );

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  void getCameras(SoState* state, SoPath* scene, float visibilityLength, SoNodeList& lightCams) override;

protected:
  virtual ~SoPointLight();
};

#endif /* _SO_POINT_LIGHT_ */
