/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R.ALBOU (May 2002)
**=======================================================================*/
#ifndef  _SO_SHADOW_STYLE_
#define  _SO_SHADOW_STYLE_


#include <Inventor/nodes/SoNode.h>
#include <Inventor/fields/SoSFBitMask.h>


class SoGLShadowMapping ;

/**
 * @VSGEXT Shadow style property node.
 *
 * @ingroup PropertyNodes
 *
 * @DESCRIPTION
 * This node specifies the shadow style for all subsequent SoShadowGroup nodes.
 * The shadow style is used to determine if shapes cast a shadow
 * and/or can be shadowed.
 *
 * @FILE_FORMAT_DEFAULT
 *    ShadowStyle {
 *    @TABLE_FILE_FORMAT
 *               @TR style             @TD CASTS_SHADOW_AND_SHADOWED
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *    SoShadowGroup.
 *
 *
 */
class INVENTOR_API SoShadowStyle : public SoNode {
  SO_NODE_HEADER( SoShadowStyle );

 public:
  /**
   * Shadow style type
   */
  enum ShadowStyle {
    /**
     * Shapes neither cast a shadow nor can be shadowed.
     */
    NO_SHADOWING                  = 0x00,

    /**
     * Shapes cast a shadow (but can't be shadowed).
     */
    CASTS_SHADOW                  = 0x01,

    /**
     * Shapes can be shadowed (but don't cast a shadow).
     */
    SHADOWED                      = 0x02,

    /**
     * Shapes cast a shadow and can be shadowed.
     */
    CASTS_SHADOW_AND_SHADOWED     = 0x03
  } ;

  /**
   * Default constructor.
   */
  SoShadowStyle();

  /**
   * Shadow style. Bit flag combination of #ShadowStyle.
   * @useenum{ShadowStyle}
   */
  SoSFBitMask  style ;


 SoEXTENDER public:
  // Implement actions
  virtual void GLRender(SoGLRenderAction *action);

  /*----------------------------------------------------------------------------*/

 SoINTERNAL public:
  static void initClass() ;
  static void exitClass() ;

 protected:
  virtual ~SoShadowStyle();

};
/*----------------------------------------------------------------------------*/
#endif // _SO_SHADOW_STYLE_


