/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Ronen Barzel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SHUTTLE_
#define  _SO_SHUTTLE_

#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFBool.h>

#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/engines/SoCalculator.h>
#include <Inventor/engines/SoInterpolate.h>
#include <Inventor/sensors/SoFieldSensor.h>
#include <Inventor/sensors/SoOneShotSensor.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoShuttle
//
//  SoTranslation node oscillates between two translations
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Animated oscillating translation node.
 * 
 * @ingroup TransformNodes
 * 
 * @DESCRIPTION
 *   The SoShuttle class is derived from SoTranslation, so it applies a translation
 *   to the current transformation. Using engines connected to the @B realTime @b
 *   global field, the translation value is animated over time between two fixed
 *   translations, achieving a shuttling effect. The period of the motion can be
 *   adjusted by changing the #speed field. The current translation at any time
 *   is available in the @B translation @b field, inherited from SoTranslation
 * 
 * @FILE_FORMAT_DEFAULT
 *    Shuttle {
 *    @TABLE_FILE_FORMAT
 *       @TR translation    @TD 0 0 0
 *       @TR translation0   @TD 0 0 0
 *       @TR translation1   @TD 0 0 0
 *       @TR speed          @TD 1
 *       @TR on             @TD TRUE
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction,  SoGetBoundingBoxAction,  SoRayPickAction @BR
 *        Concatenates interpolated translation value with the current transformation
 *        matrix.
 * 
 *    SoGetMatrixAction @BR
 *        Returns transformation matrix specified by the interpolated translation.
 * 
 * 
 * @SEE_ALSO
 *    SoPendulum,
 *    SoRotor
 * 
 * 
 */
class INVENTOR_API SoShuttle : public SoTranslation {

  SO_NODE_HEADER(SoShuttle);

 public:
  // Fields
  SoSFVec3f           translation0;
  /**
   * These define the two fixed translations that are interpolated to create the
   * shuttling motion.
   * 
   */
  SoSFVec3f           translation1;
  /**
   * Defines the speed of the shuttle, in cycles per second.
   * 
   */
  SoSFFloat           speed;
  /**
   * Allows applications to enable or disable the motion easily.
   * 
   */
  SoSFBool            on;

  /**
   * Creates a shuttle node with default settings.
   */
  SoShuttle();

 SoEXTENDER public:
  // overload write method not to write internal engines
  virtual void        write(class SoWriteAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

  // overload notify method to check for field updates
  virtual void notify(SoNotList *list);

 protected:
  virtual ~SoShuttle();

 private:
  // internal engines to compute the translation
  class SoElapsedTime         *time;
  class SoCalculator          *calc;
  class SoInterpolateVec3f    *interp;

  // keep track of internal connection
  class SoEngineOutput        *internalConnection;

  class SoOneShotSensor       *translationSensor;
  class SoFieldSensor         *translation0Sensor;
  class SoFieldSensor         *translation1Sensor;
  class SoFieldSensor         *onSensor;

  static void translationSensorCB(void *data, class SoSensor *sensor);
  static void onSensorCB(void *data, class SoSensor *sensor);
};

#endif /* _SO_SHUTTLE_ */

