/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

                                                             /* include files */
#ifndef _SO_TESSELLATION_CONTROL_SHADER_H_
#define _SO_TESSELLATION_CONTROL_SHADER_H_

#include <Inventor/nodes/SoShaderObject.h>

class SoNotList;

/**
 * @VSGEXT Node that defines a tessellation control shader.
 * 
 * @ingroup ShaderNodes
 * 
 * @DESCRIPTION
 *   This node defines a tessellation control shader. \n
 *
 *   See SoShaderProgram for general information about using shaders and shader parameters.
 *
 *   See parent class SoShaderObject for details about using the inherited fields.
 *
 * @B Notes:@b 
 *   - Shader object nodes cannot be inserted directly in a scene graph. \n
 *     They must be added to the @I shaderObject @i field of an SoShaderProgram node. 
 *
 * @B Limitations:@b
 *   - Tessellation shaders are currently only supported by SoBufferedShape, SoPointSet and SoIndexedPointSet.
 *
 *   - Transparency and fast editing are compatible with shader modified geometry, but most
 *     actions use the vertices of the basic shape (the vertices stored in the scene graph).
 *     This includes, for example, SoGetBoundingBoxAction, SoGetPrimitiveCountAction and SoRayPickAction.
 *
 * @FILE_FORMAT_DEFAULT
 *    TessellationControlShader {
 *      @TABLE_FILE_FORMAT
 *        @TR sourceProgram    @TD ""
 *        @TR sourceType       @TD FILENAME
 *        @TR isActive         @TD TRUE
 *        @TR parameter        @TD NULL
 *      @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *    SoFragmentShader, 
 *    SoGeometryShader, 
 *    SoShaderObject, 
 *    SoShaderProgram, 
 *    SoTessellationEvaluationShader,
 *    SoUniformShaderParameter,
 *    SoVertexShader
 *
 */
class INVENTOR_API SoTessellationControlShader : public SoShaderObject
{
  SO_NODE_HEADER(SoTessellationControlShader);

public:
  /**
   * Constructor.
   */
  SoTessellationControlShader();

  /**
   * Returns true if tessellation control shaders in the specified language are supported by 
   * your graphics board.
   * When using a debug build of Open Inventor, some "no context available"
   * warning messages may be generated. You can ignore them or see
   * SoGLExtension for an example of using SoGLContext to avoid them.
   */
  static SbBool isSupported(SoShaderObject::SourceType sourceType, SoState* state=NULL) ;

  /** Returns the shader type */
  virtual ShaderType getShaderType() const
  { return TESSELLATION_CONTROL_SHADER; }

SoINTERNAL public:

  /** register class in database */
  static void initClass();

  /** unregister class in database */
  static void exitClass();

  virtual void notify(SoNotList* list);

  /** Parses the shader program to retrieve the output layout. */
  const SbString& getOutputLayout();

protected:
  /** Destructor */
  virtual ~SoTessellationControlShader();

private:
  /** The current output layout of this geometry shader object */
  SbString m_outputLayout;

  /** Cache for stored output layout value */
  bool m_outputLayoutDirty;
};

#endif /* _SO_TESSELLATION_CONTROL_SHADER_ */

