/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TEXTURE_
#define  _SO_TEXTURE_

#include <Inventor/fields/SoSFVec4f.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/fields/SoSFImage.h>
#include <Inventor/fields/SoSFString.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFColor.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/nodes/SoNode.h>
#include <Inventor/sys/SoGLType.h>
#include <Inventor/elements/SoTextureImageElement.h>
#include <SoDeprecationRules.h>
#include <Inventor/SbEnums.h>
#include <Inventor/renderer/RendererResourceMacro.h>

class SoFieldSensor;
class SoNodeSensor;
class SbRasterImage;
class SoGLTexture;

/*! \cond PRIVATE */
namespace inventor {
  namespace impl{
    class SoExtTexture2Impl;
    class SoIndexedTexture2Impl;
    class SoRenderToTexturePropertyImpl;
  };
  namespace renderer{
    class RendererContext;
  }
};

namespace inventor {
namespace renderer{
  template<typename T> struct Resource;
  class FixedPipelineShader;
};
};
/*! \endcond */

#ifndef GL_COMBINE
#define GL_COMBINE 0x8570
#endif
#ifndef GL_CLAMP_TO_BORDER
#define GL_CLAMP_TO_BORDER 0x812D
#endif
#ifndef GL_CLAMP_TO_EDGE
#define GL_CLAMP_TO_EDGE 0x812F
#endif
#ifndef GL_MIRRORED_REPEAT
#define GL_MIRRORED_REPEAT 0x8370
#endif

SO_PIMPL_BASE_PUBLIC_DECLARATION(SoTexture)

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoTexture
//
//  Texture node.
//
//////////////////////////////////////////////////////////////////////////////

/** 
* Abstract base class for texture mapping nodes.
* 
* @ingroup TextureNodes
* 
* @DESCRIPTION
* This is the abstract base class for all texture image nodes.
* It defines the common methods and fields that all texture
* image nodes have. When a texture image node is encountered
* during traversal, the associated image and parameters are applied 
* to the current texture unit (see SoTextureUnit) and used to apply
* the texture to subsequent shapes.
*
* Open Inventor provides multiple texture image nodes optimized for
* different purposes, including:
*   - SoTexture2 @BR
*     The basic 2D texture image node. The image may be loaded from a file,
*     loaded from an image in memory or created by rendering a scene graph.
*
*   - SoExtTexture2 @BR
*     This node is similar to SoTexture2, but has specific optimizations that are
*     valuable for applications that load a large number of textures from files.
*
*   - SoIndexedTexture2 @BR
*     The first two nodes load an image containing color values that are directly
*     applied to the geometry. This node considers each texel to be a data value
*     that is mapped to a color using the color map defined by an SoColorMap node.
*     This is very useful for "intensity" data sets.
*
*   - SoTextureCubeMap @BR
*     This node loads a set of six images representing the faces of a cube. These
*     are "shrink wrapped" onto the geometry similar to environment mapping, but
*     without the need for a single specially warped environment image.
*
*   - SoTexture3 @BR
*     This node defines a 3D texture map. The image may be loaded from a set of
*     files or loaded directly from memory. A 3D texture may be used to load a
*     volume data set, but note that the Open Inventor VolumeViz nodes are
*     specifically implemented for this purpose (see SoVolumeData).
*
* Applications may use the #isSupported() method to check if the graphics
* hardware supports a specific texture mapping feature.
*
* @FILE_FORMAT_DEFAULT
*   This is an abstract class. See the reference page of a derived class
*   for the format and default values.
*
*
* @SEE_ALSO
*    SoComplexity,
*    SoExtTexture2,
*    SoIndexedTexture2,
*    SoMaterial,
*    SoTexture2,
*    SoTexture2Transform,
*    SoTexture3,
*    SoTextureCombiner,
*    SoTextureCoordinate2,
*    SoTextureCoordinateBinding,
*    SoTextureCoordinateFunction,
*    SoTextureCubeMap,
*    SoTextureUnit
* 
* 
*/
class INVENTOR_API SoTexture : public SoNode {

  SO_NODE_ABSTRACT_HEADER(SoTexture);

  SO_PIMPL_BASE_PUBLIC_HEADER(SoTexture);
  RENDERER_RESOURCE(SoTexture);
public:
  /**
   * Texture internal storage format. AUTO_INTERNAL_FORMAT (equivalent to RGB_FORMAT) by default.   
   */
  enum InternalFormat {
   /** Default. */
    AUTO_INTERNAL_FORMAT,
    /** ALPHA_FORMAT */
    ALPHA_FORMAT,
    /** ALPHA4 */
    SoDEPRECATED_ENUM_VALUE(9610,"Use an 8 bit type instead.") ALPHA4, 
    /** ALPHA8 */
    ALPHA8,  
    /** ALPHA12 */
    ALPHA12,  
    /** ALPHA16 */
    ALPHA16,  
    /** LUMINANCE_FORMAT */
    LUMINANCE_FORMAT,  
    /** LUMINANCE4 */
    SoDEPRECATED_ENUM_VALUE(9610,"Use an 8 bit type instead.") LUMINANCE4,  
    /** LUMINANCE8 */
    LUMINANCE8,  
    /** LUMINANCE12 */
    LUMINANCE12,  
    /** LUMINANCE16 */
    LUMINANCE16,  
    /** LUMINANCE_ALPHA */
    LUMINANCE_ALPHA, 
    /** LUMINANCE4_ALPHA4 */
    LUMINANCE4_ALPHA4,  
    /** LUMINANCE6_ALPHA2 */
    LUMINANCE6_ALPHA2,  
    /** LUMINANCE8_ALPHA8 */
    LUMINANCE8_ALPHA8,  
    /** LUMINANCE12_ALPHA4 */
    LUMINANCE12_ALPHA4, 
    /** LUMINANCE12_ALPHA12 */
    LUMINANCE12_ALPHA12, 
    /** LUMINANCE16_ALPHA16 */
    LUMINANCE16_ALPHA16, 
    /** INTENSITY_FORMAT */
    INTENSITY_FORMAT,  
    /** INTENSITY4 */
    SoDEPRECATED_ENUM_VALUE(9610,"Use an 8 bit type instead.") INTENSITY4, 
    /** INTENSITY8 */
    INTENSITY8, 
    /** INTENSITY12 */
    INTENSITY12, 
    /** INTENSITY16 */
    INTENSITY16,  
    /** R3_G3_B2 */
    R3_G3_B2,  
    /** RGB_FORMAT */
    RGB_FORMAT,  
    /** RGB4 */
    RGB4,  
    /** RGB5 */
    RGB5,  
    /** RG8 */
    RG8,
    /** RGB8 */
    RGB8,  
    /** RGB10 */
    RGB10,  
    /** RGB12 */
    RGB12,  
    /** RGB16 */
    RGB16,  
    /** RGBA_FORMAT */
    RGBA_FORMAT,  
    /** RGBA2 */
    RGBA2,  
    /** RGBA4 */
    RGBA4,  
    /** RGB5_ALPHA1 */
    RGB5_ALPHA1,  
    /** RGBA8 */
    RGBA8,  
    /** RGB10_ALPHA2 */
    RGB10_ALPHA2,  
    /** RGBA12 */
    RGBA12,  
    /** RGBA16 */
    RGBA16, 
    /** RGBA_FLOAT32 */
    RGBA_FLOAT32, 
    /** RGB_FLOAT32 */
    RGB_FLOAT32, 
    /** ALPHA_FLOAT32 */
    ALPHA_FLOAT32, 
    /** INTENSITY_FLOAT32 */
    INTENSITY_FLOAT32, 
    /** LUMINANCE_FLOAT32 */
    LUMINANCE_FLOAT32, 
    /** LUMINANCE_ALPHA_FLOAT32 */
    LUMINANCE_ALPHA_FLOAT32, 
    /** RGBA_FLOAT16 */
    RGBA_FLOAT16, 
    /** RGB_FLOAT16 */
    RGB_FLOAT16, 
    /** ALPHA_FLOAT16 */
    ALPHA_FLOAT16, 
    /** INTENSITY_FLOAT16 */
    INTENSITY_FLOAT16, 
    /** LUMINANCE_FLOAT16 */
    LUMINANCE_FLOAT16, 
    /** LUMINANCE_ALPHA_FLOAT16 */
    LUMINANCE_ALPHA_FLOAT16, 
    /** COMPRESSED_ALPHA */
    COMPRESSED_ALPHA, 
    /** COMPRESSED_LUMINANCE */
    COMPRESSED_LUMINANCE,    
    /** COMPRESSED_LUMINANCE_ALPHA */ 
    COMPRESSED_LUMINANCE_ALPHA, 
    /** COMPRESSED_INTENSITY */
    COMPRESSED_INTENSITY, 
    /** COMPRESSED_RGB */
    COMPRESSED_RGB, 
    /** COMPRESSED_RGBA */
    COMPRESSED_RGBA,
   /**
    * @ENUM_SINCE_OIV 7.0
    */
    COMPRESSED_LUMINANCE_LATC1,
   /**
    * @ENUM_SINCE_OIV 7.0
    */
    COMPRESSED_SIGNED_LUMINANCE_LATC1,
   /**
    * @ENUM_SINCE_OIV 7.0
    */
    COMPRESSED_LUMINANCE_ALPHA_LATC2,
   /**
    * @ENUM_SINCE_OIV 7.0
    */
    COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2,
   /**
    * @ENUM_SINCE_OIV 7.0
    */
    COMPRESSED_RED_RGTC1,
   /**
    * @ENUM_SINCE_OIV 7.0
    */
    COMPRESSED_SIGNED_RED_RGTC1,
   /**
    * @ENUM_SINCE_OIV 7.0
    */
    COMPRESSED_RED_GREEN_RGTC2,
   /**
    * @ENUM_SINCE_OIV 7.0
    */
    COMPRESSED_SIGNED_RED_GREEN_RGTC2,
   /**
    * @ENUM_SINCE_OIV 9.0
    */
    DEPTH_COMPONENT16,
   /**
    * @ENUM_SINCE_OIV 9.0
    */
    DEPTH_COMPONENT24,
   /**
    * @ENUM_SINCE_OIV 9.0
    */
    DEPTH24_STENCIL8,
   /**
    * @ENUM_SINCE_OIV 10.0
    */
    R8I,
    R8UI,
    R16I,
    R16UI,
    R32I,
    R32UI,
    RG8I,
    RG8UI,
    RG16I,
    RG16UI,
    RG32I,
    RG32UI,
    RGB8I,
    RGB8UI,
    RGB16I,
    RGB16UI,
    RGB32I,
    RGB32UI,
    RGBA8I,
    RGBA8UI,
    RGBA16I,
    RGBA16UI,
    RGBA32I,
    RGBA32UI,
#ifndef HIDDEN_FROM_DOC 
    LAST_FORMAT
#endif
  };

  /** Texture Combiner Functions */
  enum Model {
   /**
    *  The texture color is multiplied by the surface color. 
    */
    MODULATE = SbEnums::TEX_MODEL_MODULATE,

   /**
    * In this mode, OpenGL requires that the specified texture image have 
    * either 3 or 4 components. 
    * For a 3-component texture, the texture color replaces the surface color.
    * For a 4-component texture, the texture color is blended with the 
    * surface color using the texture alpha value.
    * See OpenGL documentation on glTexEnv for details. 
    * 
    */
    DECAL = SbEnums::TEX_MODEL_DECAL,

   /**
    *  Blends between the surface color and a specified blend color. 
    */
    BLEND = SbEnums::TEX_MODEL_BLEND,

   /**
    *  The texture color replaces the surface color.
    *
    * @ENUM_SINCE_OIV 4.0
    */
    REPLACE = SbEnums::TEX_MODEL_REPLACE,

   /**
    * Adds incoming fragment and texture source colors.
    * 
    * @ENUM_SINCE_OIV 5.0
    */
    ADD = SbEnums::TEX_MODEL_ADD,

   /**
    * Provides a wide range of programmable combiner functions using the incoming
    * fragment color, texture source color, texture constant color, and the
    * result of the previous texture environment stage as possible parameters.
    * 
    * @ENUM_SINCE_OIV 5.0
    */
    COMBINE = SbEnums::TEX_MODEL_COMBINE

  };

  /** Texture wrap type */
  enum Wrap {
   /**
    *  Repeats texture outside 0-1 texture coordinate range.
    */
    REPEAT = SbEnums::TEX_ADDRESS_REPEAT,

   /**
    *  Clamps texture coordinates to lie within 0-1 range.
    *  This wrap type is deprecated in OpenGL core profile.
    *  Consider using CLAMP_TO_EDGE instead.
    */
    CLAMP = SbEnums::TEX_ADDRESS_CLAMP,

   /**
    * Clamps texture coordinates to a range coinciding with the
    * centers of the border texels of a texture map at each mipmap level. @BR
    *
    * @ENUM_SINCE_OIV 5.0
    */
    CLAMP_TO_BORDER         = SbEnums::TEX_ADDRESS_CLAMP_BORDER,

   /**
    * Clamps texture coordinates to a range coinciding with the
    * centers of the edge texels of a texture map at each mipmap level. @BR
    *
    * @ENUM_SINCE_OIV 5.0
    */
    CLAMP_TO_EDGE         = SbEnums::TEX_ADDRESS_CLAMP_TO_EDGE,

   /**
    * The texture image is repeated in such a way that every odd repetition is a mirror
    * image. @BR
    *
    * @ENUM_SINCE_OIV 5.0
    */
    MIRRORED_REPEAT         = SbEnums::TEX_ADDRESS_MIRROR_REPEAT

  };

 /**
  * Specifies the OpenGL filtering method for minification and magnification.
  * AUTO is the default value. In this case Open Inventor automatically
  * selects the filtering method depending on SoComplexity::textureQuality.
  */
  enum Filter
  {
    /** AUTO */
    AUTO = SbEnums::TEX_FILTER_AUTO,
    /** NEAREST */
    NEAREST = SbEnums::TEX_FILTER_NEAREST,
    /** LINEAR */
    LINEAR = SbEnums::TEX_FILTER_LINEAR,
    /** NEAREST_MIPMAP_NEAREST */
    NEAREST_MIPMAP_NEAREST = SbEnums::TEX_FILTER_NEAREST_MIPMAP_NEAREST,
    /** NEAREST_MIPMAP_LINEAR */
    NEAREST_MIPMAP_LINEAR = SbEnums::TEX_FILTER_NEAREST_MIPMAP_LINEAR,
    /** LINEAR_MIPMAP_NEAREST */
    LINEAR_MIPMAP_NEAREST = SbEnums::TEX_FILTER_LINEAR_MIPMAP_NEAREST,
    /** LINEAR_MIPMAP_LINEAR */
    LINEAR_MIPMAP_LINEAR = SbEnums::TEX_FILTER_LINEAR_MIPMAP_LINEAR
  } ;
  
 /**
  * 
  */
  enum HW_Feature {  
 /**
   * Check support for non-power-of-2 textures      
   */  
    HW_NPOT = 0,

  /**
   * Check support for floating point texture format
   */  
    HW_FLOATFORMAT,

  /**
   * Check support for depth textures
   */  
    HW_DEPTHFORMAT,

  /**
   * Check support for automatic mipmap generation
   */  
    HW_AUTOMIPMAP,

  /**
   * Check support for texture coordinates border clamp
   */  
    HW_BORDER_CLAMP,

  /**
   * Check support for texture coordinates edge clamp
   */  
    HW_EDGE_CLAMP,

  /**
   * Check support for texture coordinates mirrored repeat
   */  
    HW_MIRRORED_REPEAT,

  /**
   * Check support for DDS support (S3TC)
   */  
    HW_COMPRESSION_S3TC,

  /**
    * Check support for texture_compression_latc
    */
    HW_COMPRESSION_LATC,

  /**
   * Check support for texture_compression_rgtc
   */
   HW_COMPRESSION_RGTC,

#ifndef HIDDEN_FROM_DOC 
    HW_LAST
#endif
  };

  /**
   * Internal format for texture storage.
   * If not available on the graphics device, internalFormat is set back to AUTO_INTERNAL_FORMAT.
   * Use enum #InternalFormat. Default is AUTO_INTERNAL_FORMAT. If internal format is set to 
   * AUTO_INTERNAL_FORMAT texture precision could only be 16-bit maximum. To go beyond this
   * limitation, you must set the internal format to the needed value.
   *
   * @FIELD_SINCE_OIV 6.0
   */
  SoSFEnum internalFormat;

 /**
  * 
  * Enables storage of textures on the graphics board in compressed form.
  * The application supplies textures as usual, then OpenGL compresses the
  * textures. 
  * This can reduce usage of texture memory significantly, depending on 
  * the texture image.@BR
  * 
  * To use this option, you must be using OpenGL 1.3 or higher, or your
  * board must support the OpenGL GL_ARB_texture_compression extension.
  *
  * @FIELD_SINCE_OIV 4.0
  */
  SoSFBool enableCompressedTexture;

 /**
  * Indicates what to do when texture coordinates in the S (horizontal) 
  * direction lie outside the range 0-1.
  * Use enum #Wrap. Default is REPEAT.
  */
  SoSFEnum wrapS;

 /**
  * Specifies how to map texture onto surface.
  * Use enum #Model. Default is MODULATE.
  */
  SoSFEnum model;

 /**
  * Color used for BLEND model.
  */
  SoSFColor blendColor;

 /**
  * Enables borders for textures. This means that the 
  * border is already in the texture.
  *
  * @FIELD_SINCE_OIV 5.0
  */
  SoSFBool enableBorder;

 /**
  * Defines border color used for border texture filtering. This
  * value is only used if #enableBorder is FALSE. 
  *
  * @FIELD_SINCE_OIV 5.0
  */
  SoSFVec4f borderColor;

 /**
  * Specifies on a per-texture object basis, the maximum degree of anisotropy
  * to account for in texture filtering. If the specified value is greater than
  * the maximum supported by the graphics board, the value is clamped to
  * GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT.@BR
  * 
  * To use this option, you must be using OpenGL 1.1 or higher, or your
  * board must support the OpenGL GL_EXT_filter_anisotropic extension.
  *
  * @FIELD_SINCE_OIV 5.0
  */
  SoSFFloat maxAnisotropy;

 /**
  * Specifies the OpenGL minFilter.
  * Use enum #Filter. Default is AUTO.
  * The minification filter is used when the rendered size of the geometry
  * is smaller than the texture image to be applied (typically far away objects).
  * Effectively controls whether the GPU will select the "nearest" texel in the
  * texture image or do linear interpolation (smoothing) or even interpolate
  * between mipmap levels (subsampled versions of the base image).
  * Using NEAREST may allow better performance, but the LINEAR options
  * produce much higher quality rendering.
  *
  * The default value (AUTO) means that the minification filter setting is
  * actually controlled by the SoComplexity::textureQuality field.
  *
  * @FIELD_SINCE_OIV 5.0
  */
  SoSFEnum minFilter;

 /**
  * Specifies the OpenGL magFilter. 
  * Use enum #Filter. Default is AUTO. Only the following
  * Filter values are valid: AUTO, NEAREST, and LINEAR. 
  *
  * The magnification filter is used when the rendered size of the geometry
  * is larger than the texture image to be applied (typically near objects).
  * Effectively controls whether the GPU will select the "nearest" texel in the
  * texture image or do linear interpolation (smoothing).
  * Using NEAREST may allow better performance, but the LINEAR options
  * produce much higher quality rendering.
  *
  * Only the values NEAREST and LINEAR are valid in this field (see OpenGL specification).
  *
  * The default value (AUTO) means that the magnification filter setting is
  * actually controlled by the SoComplexity::textureQuality field.
  *
  * @FIELD_SINCE_OIV 5.0
  */
  SoSFEnum magFilter;

  /** File Type possible values. */
  enum FileType
  {
    /** Unknown file */
    UNKNOWN,
    /** RGB */
    RGB,
    /** SGI */
    SGI,
    /** TIFF */
    TIFF,
    /** GIF */
    GIF,
    /** JPEG */
    JPEG,
    /** BMP */
    BMP,
    /** PNG */
    PNG,
    /** JPEG2000 */ 
    JPEG2000,
    /** DDS */
    DDS,
    /** HDRI */
    HDRI,
    /** NUM_FILETYPES */
    NUM_FILETYPES
  };

 /**
  * Sets the texture file format. Default is UNKNOWN. If file type is set to
  * UNKNOWN, Open Inventor tries to determine the file type from the file name
  * extension (e.g., @B foo@b.@B gif @b implies a GIF file). If the set or
  * determined file type is not UNKNOWN, Open Inventor attempts to read the file as
  * that format. If this fails, Open Inventor will try reading the file as each
  * possible format in turn. It is not necessary to set the file type if the image
  * file has the standard file name extension.
  */
  void setBitmapFileType(FileType in_type);

 /**
  * Gets the texture file format.
  */
  FileType getBitmapFileType(void);

 /**
  * Returns information about hardware support for various texture
  * features.
   * When using a debug build of Open Inventor, some "no context available"
   * warning messages may be generated. You can ignore them or see
   * SoGLExtension for an example of using SoGLContext to avoid them.
  */
  static SbBool isSupported(HW_Feature feature);

  /**
   * Set the state of the override field.
   * see SoNode::setOverride doc.
   */
  inline virtual void setOverride(const SbBool state)
  { override.setValue(state); }

  /**
   * Returns the state of the override field.
   */
  inline virtual SbBool isOverride() const
  { return override.getValue(); }

  /**
   * Convenience function that loads the image data from any texture file
   * supported by Open Inventor and returns an SbRasterImage object.
   * Returns null if the load fails for any reason.
   *
   * If the file type is known, you may specify it using the #FileType enum
   * and Open Inventor will use the corresponding image reader.  If filetype
   * is UNKNOWN, Open Inventor will try to automatically determine which
   * image reader should be used for the given file.
   */
  static SbRasterImage* readTexture( const SbString& filename, FileType filetype = UNKNOWN );

SoEXTENDER public:
  virtual void        doAction(SoAction *action)=0;
  virtual void        GLRender(SoGLRenderAction *action)=0;
  virtual void        callback(SoCallbackAction *action);

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  /**
   * Returns TRUE, to trigger TraversalPass update when texture
   * changes in order to manage tex that goes from transparent to non-trnasparent.
   */
  virtual bool affectsPath() const;

  SoSFBool override;

  /**
   * Specify that texture will be used to an internal usage (internal scenegraph/shader)
   * So some treatement will be bypassed :
   *  - override
   */
  SoSFBool forInternalShader;

  /** Special values to use with the field #numSamples */
  enum NumSamplesSpecialValues
  {
    /** Inherit the number of samples from the current framebuffer target textures */
    INHERIT_FROM_CURRENT_TARGET = -2,
  };

  /**
   * Specifies the number of samples in the texture.
   *
   * A value greater than 1 will make the texture multisampled.
   * Special values can also be used with this field. See #NumSamplesSpecialValues
   *
   * Default value is 1.
   */
  SoSFInt32 numSamples;

  /**
   * Adds flags to this texture usage.
   *
   * Introduced for Vulkan support which needs to know which kind of operations are going to be applied on the texture.
   *
   * Uses enum SbEnums::ImageUsage
   * Default is IMG_USAGE_DATA.
   */
  void addInternalUsage(uint32_t usage);

  /**
   * Determines the memory type.
   *
   * Introduced for Vulkan support which needs to know which kind of memory type operations are going to be applied (mapped to CPU for access, other).
   *
   * Uses enum SbEnums::MemoryType
   * Default NONE, which means auto mode.
   */
  void setMemoryType(uint32_t memoryType);

  /**
   * Returns the actual number of samples that will be used for rendering.
   *
   * This method either returns the value of the #numSamples field if it was set
   * with a value greater than or equal to 1, or the number of samples that has
   * been computed according to a special value from #NumSamplesSpecialValues.
   *
   * In the case of a special value from #NumSamplesSpecialValues:
   * - if not NULL, the SoState is used to retrieve the special value.
   * - if the SoState is NULL, the previously stored special value is used.
   */
  int getNumSamples(SoState* state = nullptr) const;

  /**
   * Returns the number of samples of the current framebuffer targets.
   * If the target textures have different number of samples, the one with the
   * greater value is returned.
   */
  static int getNumSamplesFromState(SoState* state);

  /** Update internal parameters that depend on state, such as the #numSamples value if inherited. */
  void updateFromState(SoState* state);

  enum SubImageCopyPolicy
  {
    SUBIMAGE_NO_COPY,
    SUBIMAGE_COPY,
    SUBIMAGE_NO_COPY_AND_DELETE,
  };

  /** Update the texture with the given set of sub textures*/
  void subImage(const std::vector<SoTextureImageElementBase::TextureDataConfiguration>& subTextures,
                SubImageCopyPolicy copyPolicy = SUBIMAGE_COPY);

protected:
  SoTexture();

  virtual ~SoTexture();

private:

#if SoDEPRECATED_BEGIN(9620)
  SoDEPRECATED_MEMBER_NOWARN(9620, "No longer used. mip map are always generated if needed.")
  SoSFBool useAutoMipmap;
#endif /** @DEPRECATED_END */

  /** common contructor */
  void commonConstructor();

  friend class inventor::impl::SoExtTexture2Impl;
  friend class inventor::impl::SoIndexedTexture2Impl;
  friend class inventor::impl::SoRenderToTexturePropertyImpl;
  friend struct inventor::renderer::Resource<SoTexture>;
  friend class inventor::renderer::FixedPipelineShader;
  friend class inventor::renderer::RendererContext;
};

#endif /* _SO_TEXTURE_ */

