/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Thaddeus Beier (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TEXTURE_2_TRANSFORM_
#define  _SO_TEXTURE_2_TRANSFORM_

#include <Inventor/fields/SoSFVec2f.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/nodes/SoNode.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoTexture2Transform
//
//  2D Texture transformation node.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * 2D texture transformation node.
 * 
 * @ingroup TextureNodes
 * 
 * @DESCRIPTION
 *   This node defines a 2D transformation applied to texture coordinates. If
 *   you are using multiple textures, note that this transformation is applied
 *   to the texture coordinates of the current texture unit (SoTextureUnit). 
 *   This transformation affects the way textures are applied to the surfaces 
 *   of subsequent shapes. The
 *   transformation consists of (in order) a non-uniform scale about an arbitrary
 *   center point, a rotation about that same point, and a translation. (Note: while
 *   the transformations can be thought of as being applied in that order, the GL
 *   matrices are actually premultiplied in the opposite order. Therefore, the
 *   operations are listed in the reverse order throughout this reference page.) This
 *   allows a user to change the size and position of the textures on objects.
 * 
 * @FILE_FORMAT_DEFAULT
 *    Texture2Transform {
 *    @TABLE_FILE_FORMAT
 *       @TR translation   @TD 0 0
 *       @TR rotation      @TD 0
 *       @TR scaleFactor   @TD 1 1
 *       @TR center        @TD 0 0
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction @BR
 *        Concatenates transformation with the current texture transformation.
 *        Sets: SoTextureMatrixElement
 * 
 * @SEE_ALSO
 *    SoTexture2,
 *    SoTextureCoordinate2,
 *    SoTextureCoordinateFunction,
 *    SoTextureUnit
 * 
 * 
 */
class INVENTOR_API SoTexture2Transform : public SoNode {

  SO_NODE_HEADER(SoTexture2Transform);

 public:
  // Fields
  /**
   * Translation in S and T.
   * 
   */
  SoSFVec2f           translation;
  /**
   * Counterclockwise rotation of the coordinate space, in radians. This results in
   * a clockwise rotation of the texture on the object.
   * 
   */
  SoSFFloat           rotation;
  /**
   * Scaling factors in S and T.
   * 
   */
  SoSFVec2f           scaleFactor;
  /**
   * Center point used for scaling and rotation.
   * 
   */
  SoSFVec2f           center;

  /**
   * Creates a texture transformation node with default settings.
   */
  SoTexture2Transform();

 SoEXTENDER public:
  virtual void        doAction(SoAction *action);
  virtual void        callback(SoCallbackAction *action);
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        getMatrix(SoGetMatrixAction *action);
  virtual void        pick(SoPickAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoTexture2Transform();
};

#endif /* _SO_TEXTURE_2_TRANSFORM_ */

