/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : John Rohlf (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TEXTURE_COORDINATE_BINDING_
#define  _SO_TEXTURE_COORDINATE_BINDING_

#include <Inventor/SbVertexAttributeBinding.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/nodes/SoNode.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoTextureCoordinateBinding
//
//  Texture coordinate binding node. This indicates how multiple texture 
//  coordinates are to be distributed over an object.
//
//  If there is a texture function defined, then neither a texture coordinate
//  nor a texture coordinate binding node is needed
//
//  Unlike normal bindings, only a few of the typical bindings make sense:
//  PER_VERTEX, and PER_VERTTEX_INDEXED
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Node that specifies how texture coordinates are bound to shapes.
 * 
 * @ingroup TextureNodes
 * 
 * @DESCRIPTION
 *   This node specifies how the current texture coordinates
 *   are bound to vertex-based shapes that follow in the scene graph.
 *   If you are using multiple textures, note that this binding applies to 
 *   the texture coordinates of the current texture unit (SoTextureUnit).
 *   The DEFAULT binding causes
 *   each shape to define its own default coordinates. These default coordinates
 *   typically cause a texture to be mapped across the whole surface of a shape.
 * 
 * @FILE_FORMAT_DEFAULT
 *    TextureCoordinateBinding {
 *    @TABLE_FILE_FORMAT
 *       @TR value   @TD PER_VERTEX_INDEXED
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction @BR
 *        Sets the current texture coordinate binding type.
 *        Sets: SoTextureCoordinateBindingElement
 * 
 * @SEE_ALSO
 *    SoMaterialBinding,
 *    SoNormalBinding,
 *    SoTexture2,
 *    SoTexture2Transform,
 *    SoTextureCoordinate2,
 *    SoTextureCoordinateFunction,
 *    SoTextureUnit,
 *    SoVertexShape
 * 
 * 
 */
class INVENTOR_API SoTextureCoordinateBinding : public SoNode {

  SO_NODE_HEADER(SoTextureCoordinateBinding);

 public:
    
    /** Binding value  */
  enum Binding {
    /**
     *  Current texture coordinates are applied sequentially to vertices of shape 
     */
    PER_VERTEX = SbVertexAttributeBinding::PER_VERTEX,
    /**
     *  Current texture coordinates are indexed per vertex 
     */
    PER_VERTEX_INDEXED = SbVertexAttributeBinding::PER_VERTEX_INDEXED

    // Obsolete bindings:
    ,                       // Comma to continue list
    DEFAULT = PER_VERTEX_INDEXED
  };

  // Fields
  /**
   * Specifies how to bind texture coordinates to shapes.
   * @useenum{Binding}. Default is PER_VERTEX_INDEXED.
   */
  SoSFEnum value;

  /**
   * Creates a texture coordinate binding node with default settings.
   */
  SoTextureCoordinateBinding();

 SoEXTENDER public:
  virtual void        doAction(SoAction *action);
  virtual void        callback(SoCallbackAction *action);
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        pick(SoPickAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoTextureCoordinateBinding();

  // Reads stuff into instance. Upgrades old bindings.
  virtual SbBool      readInstance(SoInput *in, unsigned short flags);
};

#endif /* _SO_TEXTURE_COORDINATE_BINDING_ */

