/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TEXTURE_COORDINATE_NORMAL_MAP_
#define  _SO_TEXTURE_COORDINATE_NORMAL_MAP_

#include <Inventor/nodes/SoTextureCoordinateFunction.h>
#include <Inventor/fields/SoSFVec3f.h>
#include <Inventor/fields/SoSFRotation.h>
#include <memory>

class TexGenEvaluatorNormalMap;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoTextureCoordinateNormalMap
//
//////////////////////////////////////////////////////////////////////////////

/** 
 * Node that specifies texture coordinates matching the vertex's
 * transformed eye-space normal
 * 
 * @ingroup TextureNodes
 * 
 * @DESCRIPTION
 * Generates texture coordinates matching the vertex's
 * transformed eye-space normal, useful for texture-based diffuse lighting models.
 * 
 * @FILE_FORMAT_DEFAULT
 *    TextureCoordinateNormalMap {
 *    @TABLE_FILE_FORMAT
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction,  SoRayPickAction @BR
 *        Sets the current texture function in the state.
 * 
 * 
 * @SEE_ALSO
 *    SoTextureCoordinateDefault,
 *    SoTextureCoordinateEnvironment,
 *    SoTextureCoordinateFunction,
 *    SoTextureCoordinatePlane,
 *    SoTextureCoordinateReflectionMap,
 *    SoTextureCubeMap
 * 
 * 
 */
class INVENTOR_API SoTextureCoordinateNormalMap : public SoTextureCoordinateFunction {

  SO_NODE_HEADER(SoTextureCoordinateNormalMap);

 public:
  // No fields

  /**
   * Creates a texture function node with default settings.
   */
  SoTextureCoordinateNormalMap();

 SoEXTENDER public:
  void                GLRender(SoGLRenderAction *action);
  void                pick(SoPickAction *action);
  void                callback(SoCallbackAction *action);
    
  void                doAction(SoAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoTextureCoordinateNormalMap();

 private:
  std::unique_ptr<TexGenEvaluatorNormalMap> m_texGenEvaluator;
};

#endif /* _SO_TEXTURE_COORDINATE_NORMAL_MAP_ */

