/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TEXTURE_COORDINATE_REFLECTION_MAP_
#define  _SO_TEXTURE_COORDINATE_REFLECTION_MAP_

#include <Inventor/nodes/SoTextureCoordinateFunction.h>
#include <Inventor/fields/SoSFVec3f.h>
#include <Inventor/fields/SoSFRotation.h>
#include <memory>

class TexGenEvaluatorReflectionMap;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoTextureCoordinateReflectionMap
//
//////////////////////////////////////////////////////////////////////////////

/** 
 * Node that specifies texture coordinates matching the
 * vertex's eye-space reflection vector.
 * 
 * @ingroup TextureNodes
 * 
 * @DESCRIPTION
 * Generates texture coordinates (s,t,r) matching the
 * vertex's eye-space reflection vector, which is useful for environment mapping without
 * the singularity inherent in sphere mapping.
 * 
 * @FILE_FORMAT_DEFAULT
 *    TextureCoordinateReflectionMap {
 *    @TABLE_FILE_FORMAT
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction,  SoRayPickAction @BR
 *        Sets the current texture function in the state.
 * 
 * 
 * @SEE_ALSO
 *    SoTextureCoordinateDefault,
 *    SoTextureCoordinateEnvironment,
 *    SoTextureCoordinateFunction,
 *    SoTextureCoordinateNormalMap,
 *    SoTextureCoordinatePlane,
 *    SoTextureCubeMap
 * 
 * 
 */
class INVENTOR_API SoTextureCoordinateReflectionMap : public SoTextureCoordinateFunction {

  SO_NODE_HEADER(SoTextureCoordinateReflectionMap);

 public:
  // No fields

  /**
   * Creates a texture function node with default settings.
   */
  SoTextureCoordinateReflectionMap();

 SoEXTENDER public:
  void                GLRender(SoGLRenderAction *action);
  void                pick(SoPickAction *action);
  void                callback(SoCallbackAction *action);
    
  void                doAction(SoAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoTextureCoordinateReflectionMap();

 private:
  std::unique_ptr<TexGenEvaluatorReflectionMap> m_texGenEvaluator;
};

#endif /* _SO_TEXTURE_COORDINATE_REFLECTION_MAP_ */

