/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Oct 2002)
**=======================================================================*/

                                                             /* include files */
#ifndef  _SO_TEXTURE_UNIT_
#define  _SO_TEXTURE_UNIT_

#include <Inventor/fields/SoSFUInt32.h>
#include <Inventor/fields/SoSFEnum.h>

#include <Inventor/nodes/SoNode.h>

#include <Inventor/elements/SoTextureUnitElement.h>

class SoGLRenderAction ;
class SoCallbackAction ;

/*----------------------------------------------------------------------------*/

/**
 * 
 * @VSGEXT Node that specifies the current texture unit and the associated mapping
 * method.
 * 
 * @ingroup TextureNodes
 * 
 * @DESCRIPTION
 *   This node specifies the current texture unit for all subsequent 2D and 3D texture nodes
 *   (for example, SoTexture2,
 *   SoTexture2Transform, SoTextureCoordinate2, SoTextureCoordinateBinding, and
 *   SoTextureCoordinateFunction).
 *
 *   If the graphics board supports multitexturing (OpenGL 1.5
 *   or GL_ARB_multitexture extension), then multiple textures,
 *   each defined by a texture unit, can be applied to the same shape. The
 *   maximum number of texture units depends on the board and can be queried
 *   using #getMaxTextureUnit.
 *
 *   
 *   Multitexturing is supported by the following shapes:
 *      - SoCone
 *      - SoCube
 *      - SoCylinder
 *      - SoFaceSet
 *      - SoIndexedFaceSet
 *      - SoIndexedQuadMesh
 *      - SoIndexedTriangleStripSet
 *      - SoQuadMesh
 *      - SoSphere
 *      - SoTriangleStripSet
 *   
 *   Each texture unit is defined by the following texture properties:
 *      - image of the texture (derived from SoTexture)
 *      - texture coordinates (SoTextureCoordinate2, SoTextureCoordinate3, SoTextureCoordinateBinding, etc.)
 *      - automatic texture coordinates generation (derived from SoTextureCoordinateFunction)
 *      - stack of matrix transforms (SoTexture2Transform, SoTexture3Transform, SoMatrixTransform, etc.)
 *      - mapping method: image mapping or bump mapping.
 *
 *   @B Limitations@b:
 *    
 *     - Multitexturing is not supported for non convex shapes (SoShapeHints::UNKNOWN_FACE_TYPE).
 *
 *     - Automatic texture coordinate generation (SoTextureCoordinateFunction) is not possible 
 *       for the bump mapping method.
 *
 *     - When not using shaders, only units 0 to 3 can be used.
 *
 *     - When using shaders, texture unit properties (listed above) can be defined for units 0 to 7.
 *       When shaders are used, it is also possible to use SoVertexShaderParameter to specify
 *       texture coordinates to be used by the shader(s). SoVertexShaderParameter parameter sets are
 *       limited to 32 on OpenGL3 hardware.
 *     
 * 
 * @FILE_FORMAT_DEFAULT
 *    TextureUnit {
 *      @TABLE_FILE_FORMAT
 *        @TR unit             @TD 0
 *      @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction, SoCallbackAction @BR
 *        Sets the current texture unit and the associated mapping method. 
 *        Sets: SoTextureUnitElement
 * 
 * @SEE_ALSO
 *    SoBumpMappingProperty, SoTexture2, SoTexture2Transform, SoTextureCoordinate2, 
 *    SoTextureCoordinateBinding, SoTextureCoordinateFunction.
 *
 * 
 */
class INVENTOR_API SoTextureUnit : public SoNode {  
  SO_NODE_HEADER(SoTextureUnit) ;


 public:
  
  /**
   * Specifies the texture unit identifier. Can range from
   * 0 to the largest texture unit, which is getMaxTextureUnit()-1. 
   * Values greater than the largest texture unit are
   * clamped at the largest texture unit.
   */
  SoSFUInt32 unit ;

  /**
   * Constructor.
   */
  SoTextureUnit() ;

  /**
   *  Returns the maximum number of texture units. This is the max which
   *  can be used when a shader is on state. Without shaders, only the first 4 units 
   *  (0..3) can be used.
   */
  static unsigned int getMaxTextureUnit(SoState* state=NULL) ;
   
 SoEXTENDER public:
  virtual void  doAction(SoAction *action);
  virtual void  callback(SoCallbackAction *action) ;
  virtual void  GLRender(SoGLRenderAction *action) ;

  
  /*----------------------------------------------------------------------------*/
  
 SoINTERNAL public:
  static void initClass() ;
  static void exitClass() ;
  
 protected:
  // Destructor
  virtual ~SoTextureUnit() ;

private:
#if SoDEPRECATED_BEGIN(10000)
  /** Mapping method possible values. */
  SoDEPRECATED_ENUM(10000,"No more used.")
  enum MappingMethod {
    /**
     * The texture stored in SoTexture2 is used as an image map texture.
     */
    IMAGE_MAPPING
  } ;

  SoDEPRECATED_FIELD(10000,"No more used.")
  SoSFEnum mappingMethod;
#endif /** @DEPRECATED_END */

} ;
/*----------------------------------------------------------------------------*/

#endif /* _SO_TEXTURE_UNIT_ */

