/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Nick Thompson (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TRANSFORM_SEPARATOR_
#define  _SO_TRANSFORM_SEPARATOR_

#include <Inventor/nodes/SoGroup.h>

/*! \cond PRIVATE */
namespace inventor {
  namespace node {
    class SoSetMatrix;
  }
}
/*! \endcond */

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoTransformSeparator
//
//  TransformSeparator group node: isolates any transformations under
//  the node from the rest of the graph. In effect, this node acts as
//  a separator for just modeling transformations; it saves the model
//  matrix before traversing children and restores it afterwards.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Group node that saves and restores transformation state.
 * 
 * @ingroup GroupNodes
 * 
 * @DESCRIPTION
 *   This group node is similar to the SoSeparator node in that it saves state before
 *   traversing its children and restores it afterwards. However, it saves only the
 *   current transformation; all other state is left as is. This node can be useful
 *   for positioning a camera, since the transformations to the camera will not
 *   affect the rest of the scene, even though the camera will view the scene.
 *   Similarly, this node can be used to isolate transformations to light sources or
 *   other objects.
 * 
 * @FILE_FORMAT_DEFAULT
 *    TransformSeparator {
 *    @TABLE_FILE_FORMAT
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction,  SoGetBoundingBoxAction,  SoGetMatrixAction,  SoRayPickAction @BR
 *        Saves the current transformation state, traverses all children, and restores
 *        the previous transformation state.
 *        Sets: SoModelMatrixElement, SoBBoxModelMatrixElement.
 * 
 * 
 * @SEE_ALSO
 *    SoResetTransform,
 *    SoTransformation
 * 
 * 
 */
class INVENTOR_API SoTransformSeparator : public SoGroup {

  SO_NODE_HEADER(SoTransformSeparator);

 public:
  // No fields

  /**
   * Creates a transform separator node with default settings.
   */
  SoTransformSeparator();

  /**
   * Constructor that takes approximate number of children.
   */
  SoTransformSeparator(int nChildren);

 SoEXTENDER public:
  // Implement actions
  virtual void        doAction(SoAction *action);
  virtual void        callback(SoCallbackAction *action);
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        pick(SoPickAction *action);
  virtual void        getBoundingBox(SoGetBoundingBoxAction *action);
  virtual void        getMatrix(SoGetMatrixAction *action);
  virtual void        getPrimitiveCount(SoGetPrimitiveCountAction *action);
  virtual void        handleEvent(SoHandleEventAction* action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoTransformSeparator();

private:

  // Node used to restore current model matrix.
  inventor::node::SoSetMatrix* m_setModelMatrix;
};

#endif /* _SO_TRANSFORM_SEPARATOR_ */

