/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Mar 2011)
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_TRIANGLE_SET_
#define  _SO_TRIANGLE_SET_

#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/nodes/SoNonIndexedShape.h>
#include <Inventor/SbPImpl.h>

// This value, when used in the numTriangles field, means that the
// corresponding set should use the rest of the vertices
#define SO_TRIANGLE_SET_USE_REST_OF_VERTICES        (-1)

class SoNormalBundle;
class SoState;

SO_PIMPL_PUBLIC_DECLARATION(SoTriangleSet)

//@TOBEWRAPPED
/**
 * Set of triangles shape node.
 *
 * @ingroup ShapeNodes
 *
 * @DESCRIPTION
 *   This node represents a 3D shape defined by a set of triangles.
 *
 *   This shape node constructs triangles from the vertices located at the coordinates 
 *   specified in the #vertexProperty field (from SoVertexShape), or the current 
 *   inherited state. For optimal performance, the #vertexProperty field is recommended.
 *
 *   Each triangle is defined by three vertices, starting at #startIndex.
 *   The #numTriangles field specifies the number of triangles in the set.
 *   If numTriangles is -1 (default), then all vertices are used and the number of triangles
 *   is the number of vertices divided by three.  Setting numTriangles to zero means
 *   there are no triangles in the set (the bounding box is empty).  An
 *   error message is generated in the debug build if there are not enough vertices
 *   to make the specified number of triangles.
 *
 *   The coordinates of the triangle set are transformed by the current cumulative
 *   transformation. The triangles are drawn with the current light model and drawing
 *   style.
 *
 *   Treatment of the current material and normal binding is as follows: The PER_PART
 *   and PER_FACE bindings specify a material or normal for each triangle. The _INDEXED
 *   bindings are equivalent to their non-indexed counterparts. The default material
 *   binding is OVERALL. The default normal binding is PER_VERTEX.
 *
 *   If any normals (or materials) are specified, Open Inventor assumes you provide
 *   the correct number of them, as indicated by the binding. You will see unexpected
 *   results if you specify fewer normals (or materials) than the shape requires. If
 *   no normals are specified, they will be generated automatically.
 *
 *   Limitations:
 *   - Due to limitations of the OpenGL VBO (vertex buffer object) rendering model, it is not possible
 *     to use VBO rendering (and performance may be lower) if either the normal binding or the material
 *     binding is set to either PER_PART(_INDEXED) or PER_FACE(_INDEXED).
 *
 *   @NODE_SINCE_OIV 8.6
 *
 * @FILE_FORMAT_DEFAULT
 *    TriangleSet {
 *    @TABLE_FILE_FORMAT
 *       @TR vertexProperty   @TD NULL
 *       @TR startIndex       @TD 0
 *       @TR numTriangles     @TD -1
 *    @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *        Draws triangles based on the current coordinates, normals, materials, drawing
 *        style, and so on.
 *
 *    SoRayPickAction @BR
 *        Picks triangles based on the current coordinates and transformation. Details about
 *        the intersection are returned in an SoFaceDetail.
 *
 *    SoGetBoundingBoxAction @BR
 *        Computes the bounding box that encloses all vertices of the triangle set with the
 *        current transformation applied to them. Sets the center to the average of the
 *        coordinates of all vertices.
 *
 *    SoCallbackAction @BR
 *        If any triangle callbacks are registered with the action, they will be invoked
 *        for each successive triangle generated from each triangle in the set.
 *
 *
 * @SEE_ALSO
 *    SoCoordinate3,
 *    SoDrawStyle,
 *    SoIndexedTriangleSet,
 *    SoFaceDetail,
 *    SoFullSceneAntialiasing,
 *    SoVertexProperty,
 *    SoShapeHints
 *
 *
 */
class INVENTOR_API SoTriangleSet : public SoNonIndexedShape
{
  SO_NODE_HEADER(SoTriangleSet);
  SO_PIMPL_PUBLIC_HEADER(SoTriangleSet)

public:

  /**
   * Number of triangles in the set.
   * Default is SO_TRIANGLE_SET_USE_REST_OF_VERTICES, meaning to use all the vertices 
   * given, so the number of triangles is number of vertices divided by 3.
   */
  SoSFInt32 numTriangles;

  /**
   * Creates a triangle set node with default settings.
   */
  SoTriangleSet();

SoEXTENDER public:
  // Implement actions

  /** @copydoc SoNonIndexedShape::GLRender */
  virtual void GLRender( SoGLRenderAction* action );

  /** @copydoc SoNonIndexedShape::getPrimitiveCount */
  virtual void getPrimitiveCount( SoGetPrimitiveCountAction* action );

  /** @copydoc SoNonIndexedShape::generateDefaultNormals */
  virtual void generateDefaultNormals( SoState* state,
                                       const SbVec3f* coords,
                                       int numCoords,
                                       SoNormalBundle* nb,
                                       SbBool storeRef = FALSE );

  /** Disable tangents generation for triangle shapes */
  virtual void shouldGenerateTangents( SoGLRenderAction* /*action*/, const SoShapeStyleElement* /*shapeStyle*/ ) {}

SoINTERNAL public:

  /** @copydoc SoNonIndexedShape::initclass */
  static void initClass();

  /** @copydoc SoNonIndexedShape::exitClass */
  static void exitClass();

  virtual int getNumVert( SoState* state = NULL );

  virtual int getNumPrim( SoState* state = NULL );

protected:

  // This enum is used to indicate the current material or normal binding
  enum Binding {
    OVERALL,
    PER_FACE,
    PER_VERTEX
  };

  //Free memory
  virtual void exitRender( SoState* state, 
                           int stateFlag,
                           SoTextureCoordinateBundle* tcb,
                           SoTextureCoordinate3Bundle* tc3b);

  virtual void countPrim( SoState* state = NULL );

  // Generates triangles representing faces
  virtual void generatePrimitives( SoAction* action );

  // render function
  void doRendering( SoGLRenderAction* action, const SoShapeStyleElement* shapeStyle );

  // Overrides standard method to create an SoFaceDetail instance
  virtual SoDetail* createTriangleDetail( SoRayPickAction* action,
                                          const SoPrimitiveVertex* v1,
                                          const SoPrimitiveVertex* v2,
                                          const SoPrimitiveVertex* v3,
                                          SoPickedPoint* pp);

  /** Destructor */
  ~SoTriangleSet();

SoINTERNAL public:

  // reset numTris to -1, to rechecks SO_USE_REST_OF_VERTICES usage when notified
  virtual void notify( SoNotList* list );

private:

  friend class SoVolumeTriangleSetDl;
};

#endif /* _SO_TRIANGLE_SET_ */

