/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TRIANGLE_STRIP_SET_
#define  _SO_TRIANGLE_STRIP_SET_

#include <Inventor/fields/SoMFInt32.h>
#include <Inventor/nodes/SoNonIndexedShape.h>
#include <Inventor/SbPImpl.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoTriangleStripSet
//
//  Triangle strip set node. Each strip in the set consists of n
//  vertices located at consecutive entries in the current
//  coordinates. The startIndex field gives the starting coordinate
//  index for the first strip. If materials or normals are bound to
//  vertices, they will begin at that index, as well; otherwise, they
//  will start at index 0.  The number of vertices in each strip is
//  determined by successive entries in the numVertices field.
//
//////////////////////////////////////////////////////////////////////////////

class SoCoordinateElement;
class SoVolumeTriangleStripSet;

SO_PIMPL_PUBLIC_DECLARATION(SoTriangleStripSet)

// Deprecated feature; specifying USE_REST_OF_VERTICES as the last
// value in the numVertices field will use all the points in the
// coordinate array.
#define SO_TRI_STRIP_SET_USE_REST_OF_VERTICES   (-1)

/**
 * Triangle strip set shape node.
 *
 * @ingroup ShapeNodes
 *
 * @DESCRIPTION
 *   This shape node constructs triangle strips out of vertices. The vertices may be
 *   specified in the #vertexProperty field (from SoVertexShape), or by the
 *   current inherited coordinates. For optimal performance, the
 *   #vertexProperty field is recommended.
 *
 *   SoTriangleStripSet is one of the fastest ways of drawing polygonal objects in
 *   Open Inventor. It uses the current coordinates, in order, starting with the
 *   first one. The values in the #numVertices field indicate the number of
 *   vertices to use for each triangle strip in the set. The number of values in this
 *   field determines the number of strips.
 *
 *   For example, if #numVertices has the values [3,5], coordinates 1, 2, and 3
 *   would be used for the first triangle strip and coordinates 4, 5, 6, 7, and 8
 *   would be used for the second strip. This would result in 1 triangle in the first
 *   strip and 3 in the second.
 *
 *   The coordinates of the strips are transformed by the current cumulative
 *   transformation. The strips are drawn with the current light model and drawing
 *   style.
 *
 *   Treatment of the current material and normal binding is as follows: The PER_PART
 *   binding specifies a material or normal for each strip of the set. The PER_FACE
 *   binding specifies a material or normal for each triangle. The _INDEXED bindings
 *   are equivalent to their non-indexed counterparts. The default normal binding is
 *   PER_VERTEX. The default material binding is OVERALL.
 *
 *   If any normals (or materials) are specified, Open Inventor assumes you provide
 *   the correct number of them, as indicated by the binding. You will see unexpected
 *   results if you specify fewer normals (or materials) than the shape requires. If
 *   no normals are specified, they will be generated automatically.
 *
 *   To render triangles that are not in strips, see the SoTriangleSet node.
 *
 *   Limitations:
 *   - Currently does not use OpenGL VBOs (vertex buffer objects) for rendering.
 *     For very large geometry, performance may be better using SoIndexedTriangleStripSet.
 *
 * @FILE_FORMAT_DEFAULT
 *    TriangleStripSet {
 *    @TABLE_FILE_FORMAT
 *       @TR vertexProperty   @TD NULL
 *       @TR startIndex       @TD 0
 *       @TR numVertices      @TD -1
 *    @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *        Draws a strip set based on the current coordinates, normals, materials, drawing
 *        style, and so on.
 *
 *    SoRayPickAction @BR
 *        Picks on the strip set based on the current coordinates and transformation.
 *        Details about the intersection are returned in an SoFaceDetail.
 *
 *    SoGetBoundingBoxAction @BR
 *        Computes the bounding box that encloses all vertices of the strip set with the
 *        current transformation applied to them. Sets the center to the average of the
 *        coordinates of all vertices.
 *
 *    SoCallbackAction @BR
 *        If any triangle callbacks are registered with the action, they will be invoked
 *        for each successive triangle forming the strips of the set.
 *
 *
 * @SEE_ALSO
 *    SoCoordinate3,
 *    SoDrawStyle,
 *    SoFaceDetail,
 *    SoFaceSet,
 *    SoFullSceneAntialiasing,
 *    SoIndexedTriangleStripSet,
 *    SoQuadMesh,
 *    SoTriangleSet,
 *    SoVertexProperty
 *
 *
 */
class INVENTOR_API SoTriangleStripSet : public SoNonIndexedShape
{
  SO_NODE_HEADER(SoTriangleStripSet);
  SO_PIMPL_PUBLIC_HEADER(SoTriangleStripSet)

public:
  // Fields
  /**
   * Number of vertices in each triangle strip. The number of strips is equal to the
   * number of values in this field.
   */
  SoMFInt32 numVertices;

  /**
   * Creates a triangle strip set node with default settings.
   */
  SoTriangleStripSet();

SoEXTENDER public:
  /**
   * Implement SoGLRenderAction actions
   */
  virtual void GLRender( SoGLRenderAction* action );

  /**
   * Generates default normals using the given normal bundle.
   * Returns TRUE.
   */
  virtual void generateDefaultNormals( SoState* state,
                                       const SbVec3f* coords,
                                       int numCoords,
                                       SoNormalBundle* nb,
                                       SbBool storeRef = FALSE);

  /** Disable tangents generation for triangle shapes */
  virtual void shouldGenerateTangents( SoGLRenderAction* /*action*/, const SoShapeStyleElement* /*shapeStyle*/ ) {}

  /**
   * Implement SoGetPrimitiveCountAction actions
   */
  virtual void getPrimitiveCount( SoGetPrimitiveCountAction* action );

SoINTERNAL public:
  // returns the number of PARTS
  int getNumStrips() const;

  static void initClass();
  static void exitClass();

  //Typedef of pointer to method on TriangleStripSet;
  //This will be used to simplify declaration and initialization.
  typedef void (SoTriangleStripSet::*PMTSS)(SoGLRenderAction *);

  // return num vertices for test
  virtual int getNumVert( SoState* state = NULL );

  //return number of primitives
  virtual int getNumPrim( SoState* state = NULL );

protected:

  // Generates triangles representing strips
  virtual void generatePrimitives( SoAction* action );

  //Free memory
  virtual void exitRender( SoState* state,
                           int stateFlag,
                           SoTextureCoordinateBundle* tcb,
                           SoTextureCoordinate3Bundle* tc3b);

  // count primitives
  virtual void countPrim( SoState* state = NULL );
  
  // render function
  void doRendering( SoGLRenderAction* action, const SoShapeStyleElement* shapeStyle);

  // Overrides standard method to create an SoFaceDetail instance
  virtual SoDetail* createTriangleDetail( SoRayPickAction* action,
                                          const SoPrimitiveVertex* v1,
                                          const SoPrimitiveVertex* v2,
                                          const SoPrimitiveVertex* v3,
                                          SoPickedPoint* pp);

  virtual ~SoTriangleStripSet();

SoINTERNAL public:
  // Blow vpCache when vertexProperty field changes:
  virtual void notify( SoNotList* list );

private:

  static const int AUTO_CACHE_TSS_MIN_WITHOUT_VP;
  static const int AUTO_CACHE_TSS_MAX;
};

#endif /* _SO_TRIANGLE_STRIP_SET_ */


