/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Damien Dallarosa (Apr 2011)
** Modified by : Tristan Mehamli (Apr 2011)
**=======================================================================*/


#ifndef  SO_VIEWPORT_CLIPPING
#define  SO_VIEWPORT_CLIPPING

#include <Inventor/fields/SoSFVec2f.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/SoType.h>

class SoGLRenderAction;

//@TOBEWRAPPED
/**
 * Viewport clipping node.
 * 
 * @ingroup nodes
 * 
 * @DESCRIPTION
 *   This node specifies a clipping region on the screen defined by a 
 *   position and a size in pixels.  Any portion of a primitive outside
 *   this region will not be rendered.
 *
 *   Note that this clipping is applied in screen space after viewing
 *   and view clipping. (For OpenGL programmers, think of it as a call to glScissor.)
 *
 *   The clipping region also limits the effect of clearing the depth
 *   buffer using an SoDepthBuffer node.
 *
 *   @NODE_SINCE_OIV 8.6
 * 
 * @FILE_FORMAT_DEFAULT
 *    ViewClipping {
 *    @TABLE_FILE_FORMAT
 *       @TR   origin   @TD 0 0
 *       @TR   size     @TD 0 0
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *        Sets the clipping region.
 *        Sets: SoUpdateAreaElement
 * 
 *    SoCallbackAction,  SoRayPickAction @BR
 * 
 * @SEE_ALSO
 *    SoViewport
 *
 */
class INVENTOR_API SoViewportClipping : public SoNode 
{

  SO_NODE_HEADER( SoViewportClipping );

 public:

   /**
    * Specifies the position of the clip region in pixels.
    * (Although this is a float field, the values really
    * are pixels, not normalized units.) Default is 0,0.
    */
   SoSFVec2f origin;

   /**
    * Specifies the size of the clip region in pixels.
    * (Although this is a float field, the values really
    * are pixels, not normalized units.) Default is 0,0.
    */
   SoSFVec2f size;

   /**
    * Constructor.
    */
   SoViewportClipping();

SoEXTENDER public:

  /** default actions behavior */
  virtual void doAction(SoAction *action);

  /** @copydoc SoNode::pick */
  virtual void pick(SoPickAction *action);

  /** @copydoc SoNode::callback */
  virtual void callback(SoCallbackAction* action);

  /** @copydoc SoNode::GLRender */
  virtual void GLRender(SoGLRenderAction * action);

SoINTERNAL public:
  /** @copydoc SoNode::initClass */
  static void initClass();

  /** @copydoc SoNode::exitClass */
  static void exitClass();

protected:
  /** Destructor */
  virtual ~SoViewportClipping();

};

#endif // SO_VIEWPORT_CLIPPING


