/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Nick Thompson (MMM yyyy)
** Modified by : Paul Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_NODE_SENSOR_
#define  _SO_NODE_SENSOR_

#include <Inventor/sensors/SoDataSensor.h>

/**
 * Sensor class that can be attached to Open Inventor nodes.
 * 
 * @ingroup sensors
 * 
 * @DESCRIPTION
 *   Node sensors detect changes to nodes, calling a \if_dotnet delegate \else callback \endif whenever any
 *   field of the node or, if the node is a group node, any children of the node
 *   change.  The Open Inventor viewer classes, for example, attach a node sensor to the root of the
 *   application's scene graph in order to know when any part of the scene graph has been modified and a redraw is needed.
 *
 *   Node sensors provide methods that can be called in the
 *   \if_dotnet delegate \else callback \endif to determine exactly which node or field caused the
 *   sensor to be triggered.  However these methods only return valid information if the sensor priority
 *   was explicitly set to zero (default is 100).  Depending on the type of attached node, there are
 *   multiple possible triggers and only some of the get trigger info methods will return useful information.
 *
 *   Priority zero sensors are triggered immediately after the change.
 *   Normal priority sensors are not triggered until the next time the "delay queue" is processed.
 *   Normally this happens when the viewer / renderArea is not rendering and there are no input events to be processed.
 *
 *   The node sensor will be triggered if its \if_dotnet Schedule() \else schedule() \endif method is
 *   called.  But the trigger node, trigger field, etc. queries will return null.  Generally this method
 *   is only useful for "at some future time" sensors like SoIdleSensor or SoAlarmSensor.
 *
 *   \if_java
 *   Node sensors provide a "final" task that is called when the object the data sensor is attached to is finalized.
 *   This task should not attempt to modify the object in any way. (see setFinalTask(Runnable))
 *   \else
 *   Node sensors provide a delete \if_dotnet delegate \else callback \endif that is called just before the object the
 *   data sensor is attached to is deleted. The \if_dotnet delegate \else callback \endif should not attempt
 *   to modify the object in any way.
 *   \endif
 *
 *   See SoDataSensor for general information and code example.
 * 
 * @SEE_ALSO
 *    SoFieldSensor,
 *    SoPathSensor,
 *    SoDataSensor
 * 
 * 
 */
class INVENTOR_API SoNodeSensor : public SoDataSensor {

 public:
  /**
   * Default constructor.
   */
  SoNodeSensor();
  /**
   * Constructor that takes the callback function and data to be
   * called when the sensor is triggered.
   */
  SoNodeSensor(SoSensorCB *func, void *data);

  /**
   * Destroys the sensor, freeing up any memory associated with it after unscheduling
   * it.
   */
  virtual ~SoNodeSensor();

  /**
   * Makes this sensor detect changes to the given node.
   */
  void attach(SoNode *node);

  /**
   * Unschedules this sensor (if it is scheduled) and
   * makes it ignore changes to the scene graph. 
   */
  void detach();

  /**
   * Returns the node that this sensor is
   * sensing, or NULL if it is not attached to any node.
   */
  SoNode *getAttachedNode() const { return node; }

 private:
  SoNode *node;               // Node sensor is attached to

  // Propagates modification notification through an instance. This
  // checks to see if the node that triggered notification matches
  // the node we are attached to.
  virtual void notify(SoNotList *list);

  // Called by the attached node when it (the node) is about to be deleted
  virtual void dyingReference();

  // unlocked calls used internally for correct Multithread management
  void detach(SoNode* node);
};

#endif  /* _SO_NODE_SENSOR_ */

