/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Gavin Bell (MMM yyyy)
** Modified by : Paul Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_ONE_SHOT_SENSOR_
#define  _SO_ONE_SHOT_SENSOR_

#include <Inventor/sensors/SoDelayQueueSensor.h>

/**
 * Sensor for one-time only callbacks.
 * 
 * @ingroup sensors
 * 
 * @DESCRIPTION
 *   A one-shot sensor is triggered once after it is scheduled, when the delay queue
 *   is processed. Like all delay queue sensors, one-shot sensors with a non-zero
 *   priority are just added to the delay queue when scheduled; if they are scheduled
 *   again before the delay queue is processed nothing happens, and they are
 *   guaranteed to be called only once when the delay queue is processed. For
 *   example, a one-shot sensor whose \if_dotnet delegate \else callback \endif redraws the scene might be
 *   scheduled whenever the scene graph changes and whenever a window-system event
 *   reporting that the window changed size occurs. By using a one-shot, the scene
 *   will only be redrawn once even if a window-changed-size event occurs just after
 *   the scene graph is modified (or if several window-changed-size events occur in a
 *   row).
 *   
 *   Calling schedule() in the \if_dotnet delegate \else callback \endif is a useful way of getting
 *   something to happen repeatedly as often as possible, while still handling events
 *   and timeouts.
 *   
 *   A priority 0 one-shot sensor isn't very useful, since scheduling it is exactly
 *   the same as directly calling its \if_dotnet delegate \else callback \endif\.
 * 
 * @SEE_ALSO
 *    SoIdleSensor,
 *    SoDelayQueueSensor
 * 
 * 
 */
class INVENTOR_API SoOneShotSensor : public SoDelayQueueSensor {

 public:
  /**
   * Default constructor.
   */
  SoOneShotSensor();
  /**
   * Constructor that takes the \if_dotnet delegate \else callback \endif function and data to be
   * called when the sensor is triggered.
   * [OIV-WRAPPER-NOT-WRAP]
   */
  SoOneShotSensor(SoSensorCB *func, void *data);

  /**
   * Destroys the sensor, freeing up any memory associated with it after unscheduling
   * it.
   */
  virtual ~SoOneShotSensor();

};

#endif  /* _SO_ONE_SHOT_SENSOR_ */

