/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Pascal DOUX (Apr 1998)
**=======================================================================*/


#ifndef _SO_DECIMATOR_
#define _SO_DECIMATOR_


#include <Inventor/SbLinear.h>
#include <Inventor/simplifier/SoSimplifier.h>

class IDoDecimate;

/**
 * @VSGEXT Encapsulates an algorithm for simplifying shapes through mesh decimation.
 * 
 * @ingroup LMV
 * 
 * @DESCRIPTION
 *   This class implements a mesh decimation algorithm for simplifying shapes.
 *   
 *   Not all geometry nodes can be decimated. The following geometry nodes are
 *   decimated:
 *   
 *   - SoFaceSet @BR
 *   - SoIndexedFaceSet @BR
 *   - SoIndexedNurbsSurface @BR
 *   - SoIndexedTriangleStripSet @BR
 *   - SoNurbsSurface @BR
 *   - SoTriangleStripSet @BR
 *   
 *   The following geometry nodes are not decimated:
 *   
 *   - SoAnnoText3 @BR
 *   - SoAsciiText @BR
 *   - SoCone @BR
 *   - SoCube @BR
 *   - SoCylinder @BR
 *   - SoIndexedLineSet @BR
 *   - SoIndexedNurbsCurve @BR
 *   - SoLineSet @BR
 *   - SoNurbsCurve @BR
 *   - SoPointSet @BR
 *   - SoQuadMesh @BR
 *   - SoSphere @BR
 *   - SoText2 @BR
 *   - SoText3 @BR
 *   - Any geometry under an SoLOD @BR
 *   - Any geometry under an SoLevelOfDetail @BR
 *   - Any geometry under an SoLevelOfSimplification @BR
 *   
 *   The decimator does not decimate nodes such as SoCone, that adjust their
 *   complexity automatically (based on SoComplexity and/or the viewer-requested
 *   decimation level).
 *   Decimated geometry is always an indexed face set. 
 * 
 * @SEE_ALSO
 *    SoSimplifier,
 *    SoSimplifyAction,
 *    SoShapeSimplifyAction,
 *    SoGlobalSimplifyAction
 * 
 * 
 */
class INVENTOR_API SoDecimator : public SoSimplifier {

public:
  /**
   * Constructor.
   */
  SoDecimator ();
  /**
   * Destructor.
   */
  ~SoDecimator();

  /**
   * Starts a new shape. Shape Type defines which triangle organization to use.
   */
  virtual void beginShape(ShapeType);

  /**
   * End shape
   */
  virtual void endShape();

  /**
   * Methods used to specify data to simplify.
   */
  virtual void setVertex (const SbVec3f&);

  /**
   *  
   * Sets the shape type used for building 
   * the simplified node.
   * Only SoIndexedFaceSet and SoFaceSet are supported.
   * SoIndexedFaceSet is used by default.
   */
  virtual void setSimplifiedShapeType(SoType simplifiedShapeType) ;

  /** 
   * Performs the simplification on the shapes
   * and builds the simplified node.
   */
  virtual SoNode* simplify (float ) ;

  /**
   * Removes all shapes and reset.
   */
  virtual void clear();

  /** 
   * Verbose mode
   */
  virtual void setVerbosity(SbBool v);
  
private:
  
  SoType simplifiedShapeType ;

  IDoDecimate *decimer;

  int edge[2];
  int edgeCount;

  SbBool isModelComplete;
  
};

#endif // _SO_DECIMATOR_








