/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Oct 2009)
**=======================================================================*/
#if !defined( SO_GL_H )
#define SO_GL_H

#if !defined(GLEW_MX)
// Open Inventor use Multi-thread/context glew implementation
#define GLEW_MX
#endif

#include <Inventor/sys/glew.h>
#include <Inventor/devices/SoGLContext.h>
#include <Inventor/devices/SoGLGlew.h>

#if defined(_WIN32)
#  include <Inventor/sys/wglew.h>
#else
#  define APIENTRY
#  define WINGDIAPI
#endif

#if !defined(OIV_RENDERENGINE_GLEW)

  // GLEW generic dispatch mechanism.
  #ifdef GLEW_MX
  //Undef glew defined in case somebody already overrided them
  #  undef glewGetContext
  #  undef glxewGetContext
  #  undef eglewGetContext
  #  define glewGetContext ::SoGLContext::glewGetCurrentContext
  #  if defined(OIV_HEADLESS)
  #    define eglewGetContext ::SoGLContext::glewGetCurrentContextNative
  #  elif defined(_WIN32)
  #    define wglewGetContext ::SoGLContext::glewGetCurrentContextNative
  #  elif !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
  #    define glxewGetContext ::SoGLContext::glewGetCurrentContextNative
  #  endif // _WIN32
  #endif // GLEW_MX

#endif

#endif // SO_GL_H


