/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#if !defined(SO_GLX_H)
#define SO_GLX_H

#include <Inventor/sys/SoGL.h>

#if defined(OIV_HEADLESS)
#  include <Inventor/sys/eglew.h>
#else

#if defined(_WIN32)
#  include <Inventor/sys/wglew.h>
#else

#ifdef __APPLE__
#  include <OpenGL/OpenGL.h>
#  include <OpenGL/gl.h>
#else
#  include <X11/Intrinsic.h>
#  include <Inventor/sys/glxew.h>
#endif

//solve conflict between Qt and X11
#if defined(SOQT)

#    undef KeyPress
#    undef KeyRelease

// For SoQGLWidget
#    undef CursorShape

// For DialogViz qt widgets from QtGui
#if defined(Bool)
   typedef Bool X11_Bool;
#endif

#    undef Bool

// For QDir
#    undef Unsorted

// For QSlider
#    undef Above
#    undef Below

// For QStyleOption
#    undef None
// We need None sometimes...
#define  X11_None 0L

// #    undef FocusOut
// #    undef FocusIn
// #    undef Above

//solve conflict about INT32 and INT8 both defined into Qt and X11
#  define INT32 X11_INT32
#  define INT8 X11_INT8
#  undef INT32
#  undef INT8

#endif // InventorQt_EXPORTS

#endif

#endif

#endif // SO_GLX_H


