/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _INVENTOR_PORT_H
#define _INVENTOR_PORT_H

#include <SbTypes.h>

// kept for compatibility but no more used
#define __IvStaticImport

#ifdef __GNUC__
#define OIV_FUNCTION __PRETTY_FUNCTION__
#else
#define OIV_FUNCTION __FUNCTION__
#endif

#ifdef _WIN32


#  pragma warning( disable: 4800)
#  pragma warning( disable: 4251)

#include <Inventor/Win/SoWinBeginStrict.h>

#  include <windows.h>
#  include <winsock.h>
#  include <math.h>
#  include <string.h>
#ifdef LIBRARYBUILD
//Don't force customers to use this definition
#  define strcasecmp _stricmp
#endif

#ifndef _USE_MATH_DEFINES
#   ifdef _WIN64
#     define _USE_MATH_DEFINES
#   endif
#endif

#  include <math.h>

#ifndef _USE_MATH_DEFINES
#ifndef M_E
#  define M_E            2.7182818284590452354
#endif
#ifndef M_LOG2E
#  define M_LOG2E        1.4426950408889634074
#endif
#ifndef M_LOG10E
#  define M_LOG10E       0.43429448190325182765
#endif
#ifndef M_LN2
#  define M_LN2          0.69314718055994530942
#endif
#ifndef M_LN10
#  define M_LN10         2.30258509299404568402
#endif
#ifndef M_PI
#  define M_PI           3.14159265358979323846
#endif
#ifndef M_PI_2
#  define M_PI_2         1.57079632679489661923
#endif
#ifndef M_PI_4
#  define M_PI_4         0.78539816339744830962
#endif
#ifndef M_1_PI
#  define M_1_PI         0.31830988618379067154
#endif
#ifndef M_2_PI
#  define M_2_PI         0.63661977236758134308
#endif
#ifndef M_2_SQRTPI
#  define M_2_SQRTPI     1.12837916709551257390
#endif
#ifndef M_SQRT2
#  define M_SQRT2        1.41421356237309504880
#endif
#ifndef M_SQRT1_2
#  define M_SQRT1_2      0.70710678118654752440
#endif
#ifndef MAXFLOAT
#  define MAXFLOAT     ((float)3.40282346638528860e+38)
#endif
#endif


#if defined(_MSC_VER) && (_MSC_VER < 1300)
#  define __FUNCTION__ "NO__FUNCTION__FOR_VC6"
#endif

#ifdef bcopy
#  undef bcopy
#endif
#define bcopy(from,to,len) memcpy((to),(from),(len))

#include <SoVersion.h>

#define VC_DLL_EXPORT __declspec(dllexport)
#define VC_DLL_IMPORT __declspec(dllimport)

#include <Inventor/Win/SoWinEndStrict.h>

#include <Inventor/SoInventorImageLibName.h>

// DialogViz_EXPORTS is defined only when building DialogViz dll
#if defined(DialogVizXt_EXPORTS) || defined(DialogVizWin_EXPORTS) || defined(DialogVizQt_EXPORTS)
#  define DIALOGVIZ_API VC_DLL_EXPORT
#else
#  define DIALOGVIZ_API VC_DLL_IMPORT
#endif

// DialogVizQt_EXPORTS is defined only when building DialogVizQt dll
#ifdef DialogVizQt_EXPORTS
#  define DIALOGVIZQ_API VC_DLL_EXPORT
#else
#  define DIALOGVIZQ_API VC_DLL_IMPORT
#endif

// HardCopy_EXPORTS is defined only when building HardCopy dll
#ifdef HardCopy_EXPORTS
#  define HARDCOPY_API VC_DLL_EXPORT
#else
#  define HARDCOPY_API VC_DLL_IMPORT
#endif

// HardCopyWin_EXPORTS is defined only when building HardCopyW dll
#ifdef HardCopyWin_EXPORTS
#  define HARDCOPYW_API VC_DLL_EXPORT
#else
#  define HARDCOPYW_API VC_DLL_IMPORT
#endif

// IvTuneExtenderAPI_EXPORTS is defined only when building IvTuneExtender dll
#ifdef IvTuneExtenderAPI_EXPORTS
#  define IVTEXTENDER_API VC_DLL_EXPORT
#else
#  define IVTEXTENDER_API VC_DLL_IMPORT
#endif

// MeshViz_EXPORTS is defined only when building MeshViz dll
#ifdef MeshViz_EXPORTS
#  define MESHVIZ_API VC_DLL_EXPORT
#else
#  define MESHVIZ_API VC_DLL_IMPORT
#endif

// MeshVizWin_EXPORTS is defined only when building MeshVizWin dll
#ifdef MeshVizWin_EXPORTS
#  define MESHVIZW_API VC_DLL_EXPORT
#else
#  define MESHVIZW_API VC_DLL_IMPORT
#endif

// Inventor_EXPORTS is defined only when building Inventor dll
#ifdef Inventor_EXPORTS
#  define INVENTOR_API VC_DLL_EXPORT
#else
#  define INVENTOR_API VC_DLL_IMPORT
#endif

// InventorBase_EXPORTS is defined only when building InventorBase dll
#ifdef InventorBase_EXPORTS
#  define INVENTORBASE_API VC_DLL_EXPORT
#else
#  define INVENTORBASE_API VC_DLL_IMPORT
#endif

// InventorGL_EXPORTS is defined only when building InventorBase dll
#ifdef InventorGL_EXPORTS
#  define INVENTORGL_API VC_DLL_EXPORT
#else
#  define INVENTORGL_API VC_DLL_IMPORT
#endif

// InventorGL_EXPORTS is defined only when building InventorBase dll
#ifdef InventorImage_EXPORTS
#  define INVENTORIMAGE_API VC_DLL_EXPORT
#else
#  define INVENTORIMAGE_API VC_DLL_IMPORT
#endif

// InventorWin_EXPORTS is defined only when building InventorWin dll
#ifdef InventorWin_EXPORTS
#  define INVENTORW_API VC_DLL_EXPORT
#else
#  define INVENTORW_API VC_DLL_IMPORT
#endif
#define INVENTORXT_API INVENTORW_API

// InventorQt_EXPORTS is defined only when building InventorQt dll
#ifdef InventorQt_EXPORTS
#  define INVENTORQT_API VC_DLL_EXPORT
#else
#  define INVENTORQT_API VC_DLL_IMPORT
#endif

// InventorGui_EXPORTS is defined only when building InventorGui dll
#ifdef InventorGui_EXPORTS
#  define INVENTORGUI_API VC_DLL_EXPORT
#else
#  define INVENTORGUI_API VC_DLL_IMPORT
#endif

// IvDLCSG_EXPORTS is defined only when building IvDLCSG dll
#ifdef IvDLCSG_EXPORTS
#  define IVDLCSG_API VC_DLL_EXPORT
#else
#  define IVDLCSG_API VC_DLL_IMPORT
#endif

// IvTune_EXPORTS is defined only when building IvTune dll
#ifdef IvTune_EXPORTS
#  define IVTUNE_API VC_DLL_EXPORT
#else
#  define IVTUNE_API VC_DLL_IMPORT
#endif

// IvTunePlg_EXPORTS is defined only when building IvTune plugins
#ifdef IvTunePlg_EXPORTS
#  define IVTUNEPLG_API VC_DLL_EXPORT
#else
#  define IVTUNEPLG_API VC_DLL_IMPORT
#endif

// RemoteVizServices_EXPORTS is defined only when building RemoteViz dll
#ifdef RemoteVizServices_EXPORTS
#  define RENDERSERVICE_API VC_DLL_EXPORT
#else
#  define RENDERSERVICE_API VC_DLL_IMPORT
#endif

// RemoteVizClient_EXPORTS is defined only when building RemoteVizClient dll
#ifdef RemoteVizClient_EXPORTS
#  define RVCLIENT_API VC_DLL_EXPORT
#else
#  define RVCLIENT_API VC_DLL_IMPORT
#endif

// ScaleViz_EXPORTS is defined only when building Inv dll
#ifdef ScaleVizRemote_EXPORTS
#  define SCALEVIZREMOTE_API VC_DLL_EXPORT
#else
#  define SCALEVIZREMOTE_API VC_DLL_IMPORT
#endif

// ScaleViz_EXPORTS is defined only when building Inv dll
#ifdef ScaleViz_EXPORTS
#  define SCALEVIZ_API VC_DLL_EXPORT
#else
#  define SCALEVIZ_API VC_DLL_IMPORT
#endif

// VolumeViz_EXPORTS is defined only when building VolumeViz dll
#ifdef VolumeViz_EXPORTS
#  define VOLUMEVIZ_API VC_DLL_EXPORT
#else
#  define VOLUMEVIZ_API VC_DLL_IMPORT
#endif

// LDM_EXPORTS is defined only when building LDM dll
#ifdef LDM_EXPORTS
#  define LDM_API VC_DLL_EXPORT
#else
#  define LDM_API VC_DLL_IMPORT
#endif

// ViewerComponents_EXPORTS is defined only when building ViewerComponents dll
#ifdef ViewerComponents_EXPORTS
#  define VIEWERCOMPONENTS_API VC_DLL_EXPORT
#else
#  define VIEWERCOMPONENTS_API VC_DLL_IMPORT
#endif

// WinViewerComponents_EXPORTS is defined only when building WinViewerComponents dll
#ifdef WinViewerComponents_EXPORTS
#  define WINVIEWERCOMPONENTS_API VC_DLL_EXPORT
#else
#  define WINVIEWERCOMPONENTS_API VC_DLL_IMPORT
#endif

// MFCViewerComponents_EXPORTS is defined only when building MFCViewerComponents dll
#ifdef MFCViewerComponents_EXPORTS
#  define MFCVIEWERCOMPONENTS_API VC_DLL_EXPORT
#else
#  define MFCVIEWERCOMPONENTS_API VC_DLL_IMPORT
#endif

// QtViewerComponents_EXPORTS is defined only when building QtViewerComponents dll
#ifdef QtViewerComponents_EXPORTS
#  define QTVIEWERCOMPONENTS_API VC_DLL_EXPORT
#else
#  define QTVIEWERCOMPONENTS_API VC_DLL_IMPORT
#endif

// InventorMedical_EXPORTS is defined only when building InventorMedical dll
#ifdef InventorMedical_EXPORTS
#  define INVENTORMEDICAL_API VC_DLL_EXPORT
#else
#  define INVENTORMEDICAL_API VC_DLL_IMPORT
#endif

#ifdef OIV_ENABLE_LEAKDETECTOR
#include <vld.h>
#endif

#else /********************************************** UNIX **********************************************/

#if __GNUC__ > 3
 #define GCC_DLLEXPORT __attribute__ ((visibility("default")))
#else
 #define GCC_DLLEXPORT
#endif

//always set the attribute with GCC
#define VC_DLL_IMPORT GCC_DLLEXPORT
#define VC_DLL_EXPORT GCC_DLLEXPORT

#  include <strings.h>

#  ifndef APIENTRY
#    define APIENTRY
#  endif
#  ifndef CALLBACK
#    define CALLBACK
#  endif
#  ifndef WINGDIAPI
#    define WINGDIAPI
#  endif
#  ifndef HDC
#    define HDC void *
#  endif
#  if defined(_HP_NAMESPACE_STD)
#    include <limits>
#  endif
#  ifndef UINT
    typedef unsigned int UINT;
#  endif

#  define DIALOGVIZ_API GCC_DLLEXPORT
#  define DIALOGVIZQ_API GCC_DLLEXPORT
#  define HARDCOPY_API GCC_DLLEXPORT
#  define HARDCOPYW_API GCC_DLLEXPORT
#  define MESHVIZ_API GCC_DLLEXPORT
#  define MESHVIZW_API GCC_DLLEXPORT
#  define INVENTOR_API GCC_DLLEXPORT
#  define INVENTORW_API GCC_DLLEXPORT
#  define INVENTORXT_API GCC_DLLEXPORT
#  define INVENTORQT_API GCC_DLLEXPORT
#  define INVENTORGUI_API GCC_DLLEXPORT
#  define INVENTORGL_API GCC_DLLEXPORT
#  define INVENTORIMAGE_API GCC_DLLEXPORT
#  define INVENTORBASE_API GCC_DLLEXPORT
#  define IVDLCSG_API GCC_DLLEXPORT
#  define IVTEXTENDER_API GCC_DLLEXPORT
#  define IVTUNE_API GCC_DLLEXPORT
#  define IVTUNEPLG_API GCC_DLLEXPORT
#  define RENDERSERVICE_API GCC_DLLEXPORT
#  define RVCLIENT_API GCC_DLLEXPORT
#  define SCALEVIZ_API GCC_DLLEXPORT
#  define SCALEVIZREMOTE_API GCC_DLLEXPORT
#  define VOLUMEVIZ_API GCC_DLLEXPORT
#  define LDM_API GCC_DLLEXPORT
#  define VIEWERCOMPONENTS_API GCC_DLLEXPORT
#  define WINVIEWERCOMPONENTS_API GCC_DLLEXPORT
#  define MFCVIEWERCOMPONENTS_API GCC_DLLEXPORT
#  define QTVIEWERCOMPONENTS_API GCC_DLLEXPORT
#  define INVENTORMEDICAL_API GCC_DLLEXPORT

#  define SO_DLL_SUFFIX ""
#  define SO_LIB_SUFFIX ""

#endif /* UNIX */

#ifndef __APPLE__
typedef void* WindowPtr;
#endif

#endif /* _INVENTOR_PORT_H */


