/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : ... (MMM yyyy)
** Modified by : ... (MMM yyyy)
**=======================================================================*/


#ifndef  _SO_QT_TOUCH_SCREEN_
#define  _SO_QT_TOUCH_SCREEN_

#include <Inventor/Qt/OivQtCompat.h>
#include <Inventor/Qt/devices/SoQtDevice.h>
#include <Inventor/events/SoLocation2Event.h>
#include <Inventor/touch/SoTouchManager.h>
#include <Inventor/touch/events/SoTouchEvent.h>
#include <QTouchEvent>
#include <Inventor/Qt/SoQtRenderArea.h>

/** 
 *
 * Translates and reports Qt events for the touch screen device.
 * 
 * @ingroup touch
 * 
 * @DESCRIPTION
 *   This class represents a touch screen input device for the Qt user interface toolkit.
 *   It translates and manages messages generated by the touch screen. 
 *   When the touch screen device is registered in an SoQtRenderArea, the device is able
 *   to generate Open Inventor touch events (see SoTouchEvent) and gesture events 
 *   (see SoGestureEvent) that can be handled (for example) using an SoEventCallback node. 
 *
 *   It analyses each touch event and updates events in the SoTouchEvent table of SoTouchManager.
 *
 *   Note: Unlike SoQtMouse and SoQtKeyboard, this device must be explicitly registered
 *   with the render area / viewer by the application.
 *   \if_cpp
 *     \code
 *     QWidget *mainWindow = SoQt::init(argv[0]);
 *     . . .
 *     SoQtExaminerViewer* pViewer = new SoQtExaminerViewer(mainWindow);
 *     SoQtTouchScreen touchScreenDevice(mainWindow);
 *     pViewer->registerDevice(&touchScreenDevice);
 *     \endcode
 *   \endif
 *
 * @SEE_ALSO
 *    SoQtDevice,
 *    SoTouchManager,
 *    SoTouchEvent,
 *    SoGestureEvent
 * 
 */
class INVENTORQT_API SoQtTouchScreen : public SoQtDevice {

  Q_OBJECT

public:
  SoQtTouchScreen(SoWidget mWindow);

  virtual ~SoQtTouchScreen();

  /** @copydoc SoQtDevice::enable() */
  virtual void enable(SoWidget w, XtEventHandler f, XtPointer data,void *unused=NULL);

  /** @copydoc SoQtDevice::disable() */
  virtual void disable(SoWidget w, XtEventHandler f, XtPointer data);

  /** @copydoc SoQtDevice::translateEvent() */
  virtual const SoEvent * translateEvent(QEvent *event);

  /**
   * Gets the SoTouchManager containing events table, recognizers list and methods to use them.
   */
  SoTouchManager* getTouchManager() const;

private:
  SoTouchManager* m_touchManager;
  SoTouchEvent* translateQtTouchEvent(QEvent *qEvent);

  SoWidget m_myWindow;
  SoQtRenderArea* m_renderArea;
};

#endif /* _SO_QT_TOUCH_SCREEN_ */
