/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Tristan Mehamli (Sep 2011)
**=======================================================================*/

#ifndef IVT_COMMAND
#define IVT_COMMAND

//////////////////////////////////////////////////////////////////////////////
//
//  Class: IvtCommand
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtLibName.h>

#include <Inventor/SbBase.h>

#ifdef _WIN32
# if !defined(IvTuneExtenderAPI_EXPORTS)
#  ifndef OIV_DISABLE_AUTOLINK
#   pragma comment(lib,__IVTUNEEXTENDERAPILIB)
#  endif
# endif
#endif //win

/** 
 * @VSGEXT Abstract class for IvTune commands
 *
 * @ingroup IvTuneExtender
 *
 * @DESCRIPTION
 *
 * This abstract class provides the minimum methods to implement an 
 * IvTune command and is used to provide the do/undo/redo mechanism.
 *
 * @M_SINCE 9.0
 *
 * @SEE_ALSO
 *        IvtServices
 *
 */
class IVTEXTENDER_API IvtCommand 
{
public:
 /**
  * Apply this command.
  */
  virtual void execute() = 0;  

  /**
   * Undo this command.
   */
  virtual void undo() = 0; 

   /**
   * Redo this command.
   */
  virtual void redo() = 0;

  /**
   * Destructor.
   */
  virtual ~IvtCommand();
 

protected:
  /**
   * Constructor.
   */
  IvtCommand();
};
#endif // IVT_COMMAND


