/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Tristan Mehamli (Sep 2011)
**=======================================================================*/

#ifndef IVT_EDITOR
#define IVT_EDITOR

//////////////////////////////////////////////////////////////////////////////
//
//  Class: IvtEditor
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtLibName.h>

#include <IvTune/IvTuneExtender/IvtExtension.h>

#include <Inventor/SbString.h>
#include <Inventor/SoType.h>
#include <Inventor/SoTypedObject.h>


#ifdef _WIN32
# if !defined(IvTuneExtenderAPI_EXPORTS)
#  ifndef OIV_DISABLE_AUTOLINK
#   pragma comment(lib,__IVTUNEEXTENDERAPILIB)
#  endif
# endif
#endif //win

/** 
 * @VSGEXT Base class for implementing IvTune editors
 * 
 * @ingroup IvTuneExtender
 * 
 * @DESCRIPTION
 *   This class is a base to implement IvTune editors. It provides common methods for all editors. 
 *
 * @M_SINCE 9.0
 * 
 * @SEE_ALSO
 *    IvtExtension,
 *    IvtProfileSetting,
 *    IvtPlugin
 * 
 */
class IVTEXTENDER_API IvtEditor : public IvtExtension
{
  	Q_OBJECT
public:

  /**
   * Returns the SoType handled by this editor.
   */
  virtual SoType getHandledType(); 

  /**
   * Sets the object edited by this editor.
   *
   * @param editedObject the object edited by this editor.
   */
  virtual void setEditedObject ( SoTypedObject* editedObject );

  /**
   * Returns the object edited by this editor
   */
  virtual SoTypedObject* getEditedObject() const;

  /**
   * Returns the container of this editor.
   */
  virtual QWidget* getWidget() const;

  /**
   * Destructor.
   */
  virtual ~IvtEditor();
  
protected:
  /**
   * Constructor.
   */
  IvtEditor();

  /**
   * Type handled by this editor.
   */
  SoType m_handledType;

  /**
   * Object edited by this editor.
   */
  SoTypedObject* m_editedObject;

  /** Container of this editor. */
  QWidget* m_widget;

};

#endif // IVT_EDITOR


