/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Tristan Mehamli (Sep 2011)
**=======================================================================*/

#ifndef IVT_EXTENSION
#define IVT_EXTENSION

//////////////////////////////////////////////////////////////////////////////
//
//  Class: IvtExtension
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtLibName.h>

#include <Inventor/SbString.h>


#include <QObject>

#ifdef _WIN32
# if !defined(IvTuneExtenderAPI_EXPORTS)
#  ifndef OIV_DISABLE_AUTOLINK
#   pragma comment(lib,__IVTUNEEXTENDERAPILIB)
#  endif
# endif
#endif //win

#include <Inventor/SoModule.h>
SO_MODULE_HEADER(SoIvTuneExtender, __IVTUNEEXTENDERAPIDLL)

class IvtProfileSetting;
class IvtPlugin;

/**
 * Structure describing the common information of an extension.
 */
struct IVTEXTENDER_API IvtExtensionInfo
{
	SbString name;
	SbString description;
	SbString author;
	SbString version;
};

/** 
 * @VSGEXT Base class to implement IvTune extensions.
 * 
 * @ingroup IvTuneExtender
 * 
 * @DESCRIPTION
 *   This is the base class for implementing IvTune extensions.
 *
 * @M_SINCE 9.0
 * 
 * @SEE_ALSO
 *    IvtPlugin,
 *    IvtEditor
 * 
 */
class IVTEXTENDER_API IvtExtension : public QObject
{
  	Q_OBJECT
public:

  /**
   * Activate this extension.
   * The method is called when a profile that contains the extension is activated.
   */
  virtual void activate();

  /**
   * Deactivate this extension.
   * The method is called when a profile that contains the extension is deactivated.
   */
  virtual void deactivate();

  /**
   * Returns the information structure for this extension.
   */
  const IvtExtensionInfo&  getInfo() const ;

  /**
   * Returns the plug-in containing this extension.
   */
  IvtPlugin* getPlugin() const;

  /**
   * Returns the settings for this extension.
   * Settings could be different depending on the profile that activates the extension.
   */
  IvtProfileSetting* getProfileSetting() const;

  /**
   * Hide this extension.
   * Called when the GUI should be hidden.
   */
  virtual void hide();

  /**
   * Returns true if this extension is active.
   */
  bool isActive()const;

  /**
   * Returns true if this extension is visible.
   */
  bool isVisible() const;

  /**
   * Load this extension.
   * This method is called when the plug-in that contains the extension is loaded.
   */
  virtual void load();

  /**
   * Show this extension.
   * Called when the GUI should be shown.
   */
  virtual void show();

  /**
   * Unload this extension.
   * The method is called when the plug-in that contains the extension is unloaded
   */
  virtual void unload();
  
  /**
   * Destructor.
   */
  virtual ~IvtExtension();

SoINTERNAL public:
   /**
   * Sets the given setting for this extension.
   *
   * @param setting the setting for this extension.
   */
  void setProfileSetting( IvtProfileSetting* setting );

protected:
  /**
   * Constructor.
   */
  IvtExtension();

  /**
   * This extenion informations.
   */
  IvtExtensionInfo m_info;

private:

  /** Boolean for this extension being active. */
  SbBool	m_isActive;

  /** Boolean for this extension visibility. */
	SbBool m_isVisible;

  /** Pointer to the preference associated to this extension. */
	IvtProfileSetting* m_preference;
};

#endif // IVT_EXTENSION


