/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Tristan Mehamli (Sep 2011)
**=======================================================================*/

#ifndef IVT_PLUGIN
#define IVT_PLUGIN

//////////////////////////////////////////////////////////////////////////////
//
//  Class: IvtPlugin
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtLibName.h>

#include <Inventor/SbString.h>

#include <Inventor/STL/vector>

#ifdef _WIN32
# if !defined(IvTuneExtenderAPI_EXPORTS)
#  ifndef OIV_DISABLE_AUTOLINK
#   pragma comment(lib,__IVTUNEEXTENDERAPILIB)
#  endif
# endif
#endif //win

class IvtExtension;
class IvtShell;

/**
 * Structure describing the common information of a plug-in.
 */
struct IVTEXTENDER_API IvtPluginInfo
{
	SbString name;
	SbString description;
	SbString author;
	SbString version;
  SbString path;
  SbString fileName;
};

/** 
 * @VSGEXT Base class for implementing IvTune plug-ins.
 * 
 * @ingroup IvTuneExtender
 * 
 * @DESCRIPTION
 *   This class is the base class for implementing IvTune plug-ins.
 *   It provides the loading and release mechanism for the extension of 
 *   the plug-in, as well as methods to retrieve information about it.
 *
 * @M_SINCE 9.0
 * 
 * @SEE_ALSO
 *    IvtExtension
 * 
 */
class IVTEXTENDER_API IvtPlugin
{
public:
  /**
   * Adds an extension to this plug-in's list of extensions.
   *
   * @param ext the extension to add.
   */
  void addExtension( IvtExtension* ext );

  /**
   * Returns the extension whose name matches the given name.
   *
   * @param name the extension's name.
   */
  IvtExtension* getExtensionByName( const SbString&  name );

  /**
   * Returns the list of extensions loaded by this plug-in.
   */
   const std::vector<IvtExtension*>& getExtensions() const;

  /**
   * Returns the info structure for this plug-in.
   */
  const IvtPluginInfo& getInfo() const;

  /**
   * Load the extensions of this plug-in.
   * The method is called when the plug-in  is loaded.
   */
  virtual void load();

  /**
   * Unload the extensions of this plug-in.
   * The method is called when the plug-in is unloaded.
   */
  virtual void unload();

protected:

  /**
   * Informations on this plug-in.
   */
  IvtPluginInfo m_info;

  /** Destructor */
  virtual ~IvtPlugin() {}

private:

  /** Vectors of extensions instances. */
  std::vector<IvtExtension*> m_extensions;
};

#endif // IVT_PLUGIN


