/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Jean Paul Digeon (Sep 2011)
**=======================================================================*/

#ifndef IVT_PROFILE
#define IVT_PROFILE

//////////////////////////////////////////////////////////////////////////////
//
//  Class: IvtProfile
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtLibName.h>

#include <Inventor/SbString.h>

#include <Inventor/STL/map>
#include <Inventor/STL/list>

#include <QObject>

#ifdef _WIN32
# if !defined(IvTuneExtenderAPI_EXPORTS)
#  ifndef OIV_DISABLE_AUTOLINK
#   pragma comment(lib,__IVTUNEEXTENDERAPILIB)
#  endif
# endif
#endif //win


class IvtExtension;
class IvtProfileSetting;

/** 
 * @VSGEXT Configuration profile.
 * 
 * @ingroup IvTuneExtender
 * 
 * @DESCRIPTION
 *   This class handles IvTune extensions activated by a profile.
 *
 * @M_SINCE 9.0
 * 
 * @SEE_ALSO
 *    IvtPluginsManager
 * 
 */
class IVTEXTENDER_API IvtProfile : public QObject
{
  Q_OBJECT
public:
  
  /**
   * Activate this profile and its associated extensions.
   * It also sets the preferences associated with the extensions.
   */
  void activate();

  /**
   * Add the given extension and its preferences to this profile.
   *
   * @param extension the extension to add.
   * @param preference the preference associated to the extension.
   */
  void addExtension( IvtExtension* extension, IvtProfileSetting* preference );
  
  /**
   * Include the specified profile in this profile.
   *
   * @param profileName the name of the profile to include.
   */
  void addIncludeProfile( const SbString& profileName );

  /**
   * Deactivate this profile and its associated extensions.
   */
  void deactivate();

  /**
   * Returns a map of the extensions and their associated preferences for 
   * this profile.
   */
  const std::map<IvtExtension*, IvtProfileSetting*>& getExtensions() const;

  /**
   * Returns a list of names of the profiles included by the current profile.
   */
  const std::list<SbString>& getIncludeProfile() const;

  /**
   * Returns the name of this profile.
   */
  SbString getName() const;

  /**
   * Returns true if this profile is active.
   */
  SbBool isActive() const;

  /**
   * Remove the given extension.
   *
   * @param extension the extension to remove.
   */
  void removeExtension( IvtExtension* extension );

  /**
   * Constructor.
   *
   * @param name the name of this profile.
   */
	IvtProfile( const SbString& name );

  /**
   * Destructor.
   */
	virtual ~IvtProfile();	

private:

  /** This profile name. */
  SbString	m_name;	

  /** Boolean used to know if this profile is active. */
  SbBool m_isActive;

  /** Vectors of extensions. */
  std::map<IvtExtension*, IvtProfileSetting*> m_extensions;

  /** List of included profile */
  std::list<SbString> m_includeProfiles;
};

#endif // IVT_PROFILE

