/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Jean Paul Digeon (Sep 2011)
**=======================================================================*/

#ifndef IVT_PROFILE_SETTING
#define IVT_PROFILE_SETTING

//////////////////////////////////////////////////////////////////////////////
//
//  Class: IvtPreference
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtLibName.h>

#include <Inventor/SbString.h>

#include <Inventor/STL/map>

#ifdef _WIN32
# if !defined(IvTuneExtenderAPI_EXPORTS)
#  ifndef OIV_DISABLE_AUTOLINK
#   pragma comment(lib,__IVTUNEEXTENDERAPILIB)
#  endif
# endif
#endif //win

class IvtExtension;

/** 
* @VSGEXT IvTune extension preferences
* 
* @ingroup IvTuneExtender
* 
* @DESCRIPTION
*   This class handles settings associated with an IvTune extension in the context of a profile.
*   An active extension is an extension activated with a profile.
*   A controlled extension is an extension activated by an active or another controlled extension.
 *
 * @M_SINCE 9.0
* 
* @SEE_ALSO
*    IvtProfile,
*    IvtExtension
* 
*/
class IVTEXTENDER_API IvtProfileSetting
{
public:

  /**
   * Returns the value of the parameter from its name.
   *
   * @param name the name of the parameter.
   */
  SbString getParameter( const SbString& name ) const ;

  /**
   * Returns the list of parameters and associated values for this preference.
   */
  const std::map<SbString, SbString>& getParameters() const;

  /**
   * Set the specified parameter in this preference.
   *
   * @param name the name of the parameter.
   * @param value the value of the parameter.
   */
  void setParameter( const SbString& name, const SbString& value );

  /**
   * Add a controlled extension to the current extension (active or controlled).
   *
   * @param ext the extension to add.
   * @param setting the setting associated to the extension.
   */
  void addControlledExtension( IvtExtension* ext, IvtProfileSetting* setting );

  /**
   * Returns the list of controlled extensions and associated settings for the current profile.
   */
  const std::map<IvtExtension*, IvtProfileSetting* >& getControlledExtensions() const;

  /**
   * Set an extension which is embedded and controlled by current extension.
   *
   * @param controlledBy the extension to be controlled.
   */
  void setControlledBy( IvtExtension* controlledBy );

  /**
   * Returns null if it is an active extension (top level), otherwise the extension which 
   * is embedded and controlled by the current active extension.
   */
  IvtExtension* getControlledBy() const;

  /**
   * Constructor.
   */
  IvtProfileSetting();

  /**
   * Destructor.
   */
  virtual ~IvtProfileSetting();

private:

  /** Map of parameters for this preference. */
  std::map<SbString, SbString> m_parameters;

  /** Map of controlled extensions for this preference. */
  std::map<IvtExtension*, IvtProfileSetting* >  m_controlledExtensions;

  /** Extension controlled by an active extension */
  IvtExtension* m_controlledBy;
};

#endif // IVT_PROFILE_SETTING


