/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Tristan Mehamli (Sep 2011)
**=======================================================================*/
#ifndef IVT_SERVICES_H
#define IVT_SERVICES_H

//////////////////////////////////////////////////////////////////////////////
//
//  Class: IvtServices
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtLibName.h>

#include <Inventor/SbBase.h>

#include <QObject>

#ifdef _WIN32
# if !defined(IvTuneExtenderAPI_EXPORTS)
#  ifndef OIV_DISABLE_AUTOLINK
#   pragma comment(lib,__IVTUNEEXTENDERAPILIB)
#  endif
# endif
#endif //win

class IvtEditor;
class IvtCommand;

class SbName;
class SoField;
class SoFieldContainer;
class SoNode;
class SoType;
class SoGuiRenderArea;
class SoSceneManager;

/** 
 * @VSGEXT Class to access services provided by IvTune
 *
 * @ingroup IvTuneExtender
 *
 * @DESCRIPTION
 *
 * This class provides methods to get / set elements and
 * execute core operations in IvTune.
 *
 * @M_SINCE 9.0
 *
 * @SEE_ALSO
 *    IvtShell
 */
class IVTEXTENDER_API IvtServices : public QObject
{
	Q_OBJECT

public:

  /**
   * Execute the given command.
   *
   * @param command the command to execute.
   */
  virtual void execute( IvtCommand* command ) = 0;

  /**
   * Returns the current scene graph.
   */
  virtual SoNode* getSceneGraph() const = 0;

  /**
   * Returns the selected field in IvTune.
   */
  virtual SoField* getSelectedField() const = 0;

  /**
   * Returns the selected node in IvTune.
   */
  virtual SoFieldContainer* getSelectedNode() const = 0;

  /**
   * Redo the most recent command.
   */
  virtual void redo() = 0;

  /**
   * Set the given scene graph.
   *
   * @param sg the scene graph to set.
   */
  virtual void setSceneGraph( SoNode* sg ) =0;

  /**
   * Set the given field active in the field overview.
   *
   * @param field the field to set as active.
   */
  virtual void setSelectedField( SoField* field ) = 0;

 /**
   * Set the given node active in the node overview.
   *
   * @param node the field to set as active.
   */
  virtual void setSelectedNode( SoFieldContainer* node ) = 0;
  
  /**
   * Undo the most recent command.
   */
  virtual void undo() = 0;

  /**
   * Returns an instance of this class.
   */
  static IvtServices* getInstance();

  /**
  * If IvTune is started from an SoSceneManager, return the scene manager otherwise null.
  * If IvTune is started from an SoXXRenderArea or a derived class, return the scene manager of the render area.
  */
  virtual SoSceneManager* getSceneManager() const = 0;

   /**
   * Returns true if IvTune was launched as a standalone application.
   */
  virtual SbBool isStandaloneApplication() const = 0;	

Q_SIGNALS:

  /**
   * This signal is emitted whenever the scene graph changes.
   *
   * @param sg the new scene graph.
   */
	void sceneGraphChanged( SoNode* sg );

  /**
   * This signal is emitted whenever the selected node changes.
   *
   * @param node the new selected node.
   */
	void selectedNodeChanged( SoFieldContainer* node );

  /**
   * This signal is emitted whenever the selected field changes.
   *
   * @param field the new selected field.
   */
	void selectedFieldChanged( SoField* field );

protected:
  
  /** Constructor */
  IvtServices();

   /**
   * Destructor
   */
  virtual ~IvtServices();

  /** Singleton */
  static IvtServices* m_instance;

SoINTERNAL public:
  /**
  * If IvTune is started from a SoGuiRenderArea or a derived classes, return the render area otherwise null.
  */
  virtual SoGuiRenderArea* getRenderArea() const = 0;
};

#endif // IVT_SERVICES_H


