/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : J.HUMMEL (Dec 2002)
** Modified by : T.DUFOUR (MMM yyyy)
**=======================================================================*/
#ifndef  _SO_LDM_LARGE_DATA_MANAGEMENT_
#define  _SO_LDM_LARGE_DATA_MANAGEMENT_

class SoLDMTileManager;
class SoLDMTileVisitor;
class SoLDMNodeFrontManager;
class SoLDMTextureManager;
class SoLDMGeometry;
class SoLDMResourceManager;
class SoLDMMediator;
class SoAlgorithms;
class SoAction;

#include <Inventor/nodes/SoSubNode.h>

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

#include <LDM/SoLDM.h>
#include <Inventor/lists/SoActionMethodList.h>

/**
 * @LDMEXT Large Data Management
 *
 * @ingroup LDM
 *
 * @DESCRIPTION
 *
 * This class is only needed for advanced users who intend to extend or replace
 * internal LDM algorithms.
 *
 * This class is used by the LDM (Large Data Management)
 * managers to communicate with each other.
 *
 * [OIVNET-WRAPPER-CLASS DERIVABLE{Default}]
 */
SoEXTENDER_Documented class LDM_API SoLDMLargeDataManagement
{

public:

  /**
   * global initialization called once by the module using LDM
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void init();

  /**
   * global deinitialization called once by the module using LDM
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void finish();

  /**
   * Returns TRUE if module is currently initialized.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static bool isInitialized();

  /**
   * Constructor.
   */
  SoLDMLargeDataManagement();

  /**
   * Destructor.
   */
  virtual ~SoLDMLargeDataManagement(){};

  /**
   * The reset function is useful when using a customized LDM manager.
   * When the SoDataSet node changes data then the reset function will
   * be called if any cache needs to be deleted or any data reseted.
   */
  virtual void reset(){};

  //------------------------------------------------------------------------------

SoINTERNAL public:

  /**
   * Sets the associated data set.
   */
  void           setMediator(SoLDMMediator* m);
  inline SoLDMMediator* getMediator() const;

  /**
   * Return true if LDM must create threads
   */
  static bool needCreatingThreads();

  /**
   * This function returns the pointer on the Algorithms module use for computation.
   */
  static SoAlgorithms* getAlgorithmsInterface();

  /** True in multipipe if doing rendering in main thread */
  static bool isInMainMultipipeThread(SoAction* action);

  /** helper function, return true if  p1.id < p2.id */
  inline static bool lessId(const SoLDM::DataSetIdPair& p1, const SoLDM::DataSetIdPair& p2)
  {
    return p1.second < p2.second;
  }

  /** @internal
   * Setup a specific traversal method for the given nodeType when traversed by the internal SoLdmValuationAction.
   * This method is internal and only used as workaround/compatibility hack
   * to some application custom node. (Avizo SoScreenSwitch and SoRendeareSwitch)
   */
  static void addValuationActionMethod(const SoType& nodeType, SoActionMethod* method);

  /** @internal
   * Tell the valuation action that it cannot build a cache for current node and that it must traverse
   * at least until current node.
   * Must be called inside a node's ldmAction.
   * No effect if given action is not of type SoLdmValuationAction
   */
  static void forceValuationActionTraversal(SoAction* action);

SoINTERNAL protected :
  SoLDMTileManager* getTileManager() const;
  SoLDMTileVisitor* getTileVisitor() const;
  SoLDMGeometry     *getVVizGeometry() const;

  SoLDMNodeFrontManager* getNodeFrontManager() const;
  SoLDMTextureManager* getTextureManager() const;  
  SoLDMResourceManager* getResourceManager() const;

private:
  SoLDMMediator* m_mediator;
  static int s_initRefCount;
  static const char* s_versionString;

  static SoAlgorithms* s_algorithmsInterface;
  static bool s_envNeedCreateThread;
  // Store if there is a GPU or not. Useful to limit the initialization footprint
  // OIV_NOTUSEGPU == FALSE SoPreference
  static bool s_useGPU;
};
//--------------------------------------------------------------------------------

/*******************************************************************************/
SoLDMMediator*
SoLDMLargeDataManagement::getMediator() const
{
  return m_mediator;
}


//--------------------------------------------------------------------------------
inline SoAlgorithms*
SoLDMLargeDataManagement::getAlgorithmsInterface()
{
  return s_algorithmsInterface;
}


//--------------------------------------------------------------------------------

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif // _SO_LDM_LARGE_DATA_MANAGEMENT_


