/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef SOLDMVALUATIONACTIONINTERFACE_H
#define SOLDMVALUATIONACTIONINTERFACE_H

#include <Inventor/actions/SoSubAction.h>
#include <Inventor/actions/SoCallbackAction.h>
#include <LDM/SoLDMLargeDataManagement.h>
#include <Inventor/STL/stack>
#include <Inventor/STL/vector>

class SoLdmValuationAction;

#ifdef _WIN32
#pragma warning( push )
#pragma warning(disable:4251)
#endif

#ifndef HIDDEN_FROM_DOC

/**
 * @ingroup LDMActions
 */
class LDM_API SoLdmValuationActionInterface
{
public:
  /** Register ldm nodes */
  virtual void ldmAction(SoLdmValuationAction* action) = 0;

  /** Destructor */
  virtual ~SoLdmValuationActionInterface() 
  {};

  /** triangle callback called during ldmAction traversal when generatePrimitives is called */
  virtual void triangleCB(
    SoAction* action,
    const SoPrimitiveVertex* v0,
    const SoPrimitiveVertex* v1,
    const SoPrimitiveVertex* v2 ) const = 0;

  /** line callback called during ldmAction traversal when generatePrimitives is called */
  virtual void lineCB( SoAction* action,
    const SoPrimitiveVertex* v0,
    const SoPrimitiveVertex* v1 ) const = 0;

  /** point callback called during ldmAction traversal when generatePrimitives is called */
  virtual void pointCB( SoAction* action, const SoPrimitiveVertex* v ) const = 0;

};
#endif //HIDDEN_FROM_DOC

#ifdef _WIN32
#pragma warning( pop )
#endif

#endif // SOLDMVALUATIONACTIONINTERFACE_H


