/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef SO_DATACOMPRESSOR_BADTYPE_EXCEPTION
#define SO_DATACOMPRESSOR_BADTYPE_EXCEPTION

#include <LDM/compressors/exceptions/SoDataCompressorException.h>

/**
* @LDMEXT Data compression exception.
* @ingroup LDMCompressor
* 
* @DESCRIPTION
* This exception will be thrown by the compressor if it is asked to
* work on an unsupported data type.
*
* This class is intentionally inlined since we do not want to export std::exception from library
*
* @SEE_ALSO
* SoDataCompressorException,
* SoDataCompressor,
* SoGzipDataCompressor,
* SoJpegDataCompressor
* 
* 
*/ 
SoINTERNAL class SoDataCompressorBadTypeException : public SoDataCompressorException
{
public:
  /**
   * Construct the exception with the given message
   * @param what a string to explain the exception.
   */
  SoDataCompressorBadTypeException(const char *const& what):SoDataCompressorException(what) {}
};

#endif

