/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Jerome Hummel (Oct 2006)
**=======================================================================*/


#ifndef  _SO_DATA_RANGE_ELT_
#define  _SO_DATA_RANGE_ELT_

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

#include <Inventor/elements/SoAccumulatedElement.h>
#include <Inventor/STL/map>
#include <Inventor/STL/vector>

class SoDataRange;

/**
 * @ingroup LDMElements
 */
SoEXTENDER_Documented class LDM_API SoDataRangeElement : public SoAccumulatedElement {
  SO_ELEMENT_HEADER( SoDataRangeElement );

public:

  // Sets/Gets
  static void set(SoState* state, SoNode *node, SoDataRange*);
  static void get(SoState* state, SoDataRange*&);

  // Overrides push() method to copy values from next instance in the stack
  virtual void push(SoState *state) ;

  // Gets the data range equals to an id if exists, NULL otherwise.
  static SoDataRange* get( SoState *state, short dataRangeId);

  // Default values
  static void getDefault(SoDataRange *&);

#if SoDEPRECATED_BEGIN(9000)

  /**
   * Gets the current list of data ranges stored in the state.
   */
  SoDEPRECATED_METHOD(9000,"No longer used.")
  static void get(SoState* state, std::vector<SoDataRange*>&);

#endif /** @DEPRECATED_END */

protected:

  /** Initializes element */
  virtual void init(SoState* state);

  /** Create and return a copy of this element. */
  virtual SoElement* copyMatchInfo() const;

  /**
   * Returns TRUE if the element matches another element, based on node fields
   */
  virtual SbBool matches(const SoElement* elt) const;

SoINTERNAL public:

  typedef std::map<int, SoDataRange*> DataRangeIdMap;

  static void initClass();
  static void exitClass();


  //Gets the current list of data ranges stored in the state
  static void get(SoState* state, DataRangeIdMap&);

protected:
  struct DataRangeInfos
  {
    double min;
    double max;
    bool mapOnFullColorRange;
    int dataRangeId;
  };

  virtual void setElt( SoDataRange* );
  virtual ~SoDataRangeElement() ;

private:
  // List of data range.
  // Each data range is stored at dr->dataRangeId entry in this array.
  // If dataRangeId are different, data ranges are accumulated else replaced.
  std::map<int,SoDataRange*> m_dataRangeMap;
  int m_numDataRange;
  std::map<int,DataRangeInfos> m_dataRangeInfosMap;
  SoDataRange *m_dataRangeNode;
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif // _SO_DATA_RANGE_ELT_


