/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : P. ESTRADE (Mar 2000)
**=======================================================================*/

  
#ifndef  _SO_ROI_ELEMENT_
#define  _SO_ROI_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/SbBox.h>
#include <LDM/SoLDM.h>

class SoROI;

/**
 * @ingroup LDMElements
 */
class LDM_API SoROIElement : public SoReplacedElement
{
  SO_ELEMENT_HEADER( SoROIElement );

public:

  /** Overrides push() method to copy values from next instance in the stack */
  virtual void push(SoState* state);

  // Sets/Gets the current volume data attributes in the state
  static void set(SoState* state, SoNode *node, SoROI *ROINode);
  static void get(SoState* state, SoROI *&ROINode);

  /**
   * Returns the last traversed ROI with the given ID.
   * When dataSetId is 0, returns the last traversed ROI.
   */
  static SoROI* get(SoState* state, int dataSetId = 0);

  // Default values
  static void getDefault(SoROI *&ROINode);

protected:

  /** Initializes element */
  virtual void init(SoState* state);

  /** Returns TRUE if the element matches another element, based on node fields */
  virtual SbBool matches(const SoElement* elt) const;

  /** Create and return a copy of this element. */
  virtual SoElement* copyMatchInfo() const;

SoINTERNAL public:
  // Initializes the SoVolumeData class
  static void initClass();
  static void exitClass();

protected:
  virtual void setElt( SoROI *ROINode );

  virtual ~SoROIElement() ;

private:
  // Set copy constructor as private to avoid automatic public one
  SoROIElement(const SoROIElement&)
  {}

  SoROI* findROIById(const SoLDM::DataSetIdPairList& idPairList, int dataSetId) const;

  struct Parameters
  {
    Parameters();
    Parameters(const Parameters& other);
    Parameters(SoROI* roi);

    Parameters& operator=(const Parameters& other);
    bool operator==(const Parameters& other) const;

    SoROI* ROINode;
    SbBox3i32 box;
    int flags;
    SbBox3i32 subVolume;
    SbBool  relative;
  };

  std::map<int, Parameters> m_params;
  int m_lastId;
  static const Parameters defaultParams;
};

#endif // _SO_ROI_ELEMENT_


