/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : P. ESTRADE (Mar 2000)
**=======================================================================*/


#ifndef  _SO_TRANSFER_FUNCTION_ELEMENT_
#define  _SO_TRANSFER_FUNCTION_ELEMENT_

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

#include <Inventor/nodes/SoShaderParameter.h>

#include <Inventor/elements/SoAccumulatedElement.h>

#include <Inventor/STL/vector>
#include <Inventor/STL/map>

class SoTransferFunction;
class SoGLRenderAction;

/**
 * @ingroup LDMElements
 */
SoEXTENDER_Documented class LDM_API SoTransferFunctionElement : public SoAccumulatedElement {
  SO_ELEMENT_HEADER( SoTransferFunctionElement );

public:

  /** Sets/Gets the current volume data attributes in the state */
  static void set(SoState* state, SoNode *node, SoTransferFunction *m_transferFunctionNode);
  static void get(SoState* state, SoTransferFunction *&m_transferFunctionNode);

  /** Get the current list of transfer function stored in the state */
  static void get(SoState* state, std::vector<SoTransferFunction*>&);

  /** Default values */
  static void getDefault(SoTransferFunction *&m_transferFunctionNode);

  /** returns true if one (at least) accumulated transferFuncion contains a transparency */
  static SbBool hasTransparency(SoState *state);

  // Overrides push() method to copy values from next instance in the stack
  virtual void push(SoState *state) ;

protected:

  /** Initializes element */
  virtual void init(SoState* state);

SoINTERNAL public:
  typedef std::vector<SoTransferFunction*> TransferFunctionVector;
  typedef TransferFunctionVector::iterator TransferFunctionVectorIt;
  typedef std::map<int, SoTransferFunction*> TransferFunctionMap;

  // Initializes the SoVolumeData class
  static void initClass();
  static void exitClass();

  //Get the current list of transfer function stored in the state
  static void get(SoState* state, TransferFunctionMap& tfMap);

  /** Return true if tf->transferFunctionId == id */
  static bool idEqual(SoTransferFunction* tf, short id);

  /** Return the min tf id */
  static int getMinTransferFunctionId(SoState* state);
  /** Return the max tf id */
  static int getMaxTransferFunctionId(SoState* state);

  /** Return the tf with id transferFunctionId */
  static SoTransferFunction* get(SoState* state, int transferFunctionId);

protected:
  //List of transfer function.
  //Each transfer function is stored at tf->transferFunctionId entry in this array
  //If transferFunctionId are different, transfer functions are accumulated else replaced
  TransferFunctionMap m_transferFunctionList;

  SoTransferFunction *m_transferFunctionNode;
  int m_minTfId;
  int m_maxTfId;

  virtual void setElt( SoTransferFunction *m_transferFunctionNode );

  virtual ~SoTransferFunctionElement() ;
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif // _SO_TRANSFER_FUNCTION_ELEMENT_


