/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SF_LDMDATATRANSFORM_H_
#define  _SO_SF_LDMDATATRANSFORM_H_

#include <Inventor/fields/SoSFFieldContainer.h>

#include <LDM/nodes/SoLDMDataTransform.h>

/**
 * Field containing an SoLDMDataTransform object
 * 
 * @ingroup LDMFields
 * 
 * @DESCRIPTION
 * This field maintains a pointer to an instance of SoLDMDataTransform, correctly maintaining its
 * reference count.
 * 
 * @SEE_ALSO
 * SoLDMDataTransform, SoDataSet
 * 
 */
class LDM_API SoSFLDMDataTransform : public SoSFFieldContainer
{
  SO_SFIELD_DERIVED_HEADER(SoSFLDMDataTransform, SoLDMDataTransform*, SoLDMDataTransform*);

public:
  /** Returns current value 
   * [OIVNET-WRAPPER PROPERTY{Value},GETTER]
   */
  SoLDMDataTransform* getValue() const {
    evaluate();
    return (SoLDMDataTransform*)value;
  }

SoINTERNAL public:

  static void initClass();
  static void exitClass();
};

#endif // _SO_SF_LDMDATATRANSFORM_H_

/**/


