/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_DATASET_ID_
#define  _SO_DATASET_ID_

#include <Inventor/fields/SoSFInt32.h>

#include <Inventor/nodes/SoNode.h>

class SoAction ;
class SoSearchAction ;
class SoGLRenderAction ;
class SoCallbackAction ;

/*----------------------------------------------------------------------------*/

/**
 * @LDMEXT Property node that sets the current dataset id
 *
 * @ingroup LDMNodes
 *
 * @DESCRIPTION
 *
 * When using multiple SoDataSet nodes, the dataSet id uniquely identifies each
 * data set used in the compositing.  It also specifies the OpenGL texture unit 
 * in which the textures for each data set will be stored for use by GLSL shader
 * programs when doing render compositing.
 *
 * If an SoDataSetId node is traversed before a data set node (SoDataSet,
 * SoVolumeData, etc), the data set node's dataSetId field is ignored and the id
 * from the SoDataSetId node is used.
 *
 * In some cases we want to combine multiple data textures where each data texture
 * comes from a different data set (SoVolumeData) node.  In that case we could 
 * simply use each data set node's dataSetId field to assign each data texture
 * a unique id. However it is also possible to create multiple data textures from a
 * single data set using the SoVolumeTransform node.  In this case the same data set
 * node will be instanced in the scene graph multiple times (although its data will 
 * only be loaded in CPU memory once), but we still need to assign each data
 * texture a unique id.  This can be done using SoDataSetId nodes to specify a 
 * different data set id for each instance of the data set node. For example:
 *
 * @EXAMPLE
 * \if_cpp
 *   \code
 *     SoDataSetId* dataSetId1 = new SoDataSetId();
 *     dataSetId1->id = 1;
 *     SoDataSetId* dataSetId2 = new SoDataSetId();
 *     dataSetId2->id = 2;  
 *
 *     SoMultiDataSeparator* multiDataSep = new SoMultiDataSeparator();
 *       multiDataSep->addChild( volumeShader ); // Shader to combine volumes
 *       multiDataSep->addChild( volumeTransform1 );
 *       multiDataSep->addChild( dataSetId1 );
 *       multiDataSep->addChild( volumeData );
 *
 *       multiDataSep->addChild( volumeTransform2 );
 *       multiDataSep->addChild( dataSetId2 );
 *       multiDataSep->addChild( volumeData );   // Same data node instanced again
 *       multiDataSep->addChild( volumeRender );
 *     root->addChild( multiDataSep );
 *   \endcode
 * \endif
 * \if_dotnet
 *   \code
 *     SoDataSetId dataSetId1 = new SoDataSetId();
 *     dataSetId1.id.Value = 1;
 *     SoDataSetId dataSetId2 = new SoDataSetId();
 *     dataSetId2.id.Value = 2;
 *
 *     SoMultiDataSeparator multiDataSep = new SoMultiDataSeparator();
 *       multiDataSep.AddChild(volumeShader); // Shader to combine volumes
 *       multiDataSep.AddChild(volumeTransform1);
 *       multiDataSep.AddChild(dataSetId1);
 *       multiDataSep.AddChild(volumeData);
 *
 *       multiDataSep.AddChild(volumeTransform2);
 *       multiDataSep.AddChild(dataSetId2);
 *       multiDataSep.AddChild(volumeData);   // Same data node instanced again
 *       multiDataSep.AddChild(volumeRender);
 *     root.AddChild( multiDataSep );
 *   \endcode
 * \endif
 * \if_java
 *   \code
 *     SoDataSetId dataSetId1 = new SoDataSetId();
 *     dataSetId1.id.setValue( 1 );
 *     SoDataSetId dataSetId2 = new SoDataSetId();
 *     dataSetId2.id.setValue( 2 );
 *
 *     SoMultiDataSeparator multiDataSep = new SoMultiDataSeparator();
 *         multiDataSep.addChild(volumeShader); // Shader to combine volumes
 *         multiDataSep.addChild(volumeTransform1);
 *         multiDataSep.addChild(dataSetId1);
 *         multiDataSep.addChild(volumeData);
 *
 *         multiDataSep.addChild(volumeTransform2);
 *         multiDataSep.addChild(dataSetId2);
 *         multiDataSep.addChild(volumeData);   // Same data node instanced again
 *         multiDataSep.addChild(volumeRender);
 *      root.addChild( multiDataSep );
 *   \endcode
 * \endif
 *
 * @FILE_FORMAT_DEFAULT
 *    SoDataSetId {
 *      @TABLE_FILE_FORMAT
 *        @TR id             @TD 1
 *      @TABLE_END
 *    }
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction, SoCallbackAction @BR
 *        Sets the current dataset id
 *
 * @SEE_ALSO
 * SoDataSet
 *
 */
class LDM_API SoDataSetId : public SoNode
{
  SO_NODE_HEADER(SoDataSetId) ;

 public:

  /**
  * Data set id. @BR
  * 1 by default (texture unit 0 is reserved for the color lookup table by default).
  * The number of available texture units depends on your hardware. You can query
  * this number using SoDataSet::getMaxNumDataSet.
  *
  * @FIELD_SINCE_OIV 8.0
  */

  SoSFInt32 id ;

  /**
   * Constructor.
   */
  SoDataSetId() ;

 SoEXTENDER public:
  virtual void  doAction(SoAction *action);
  virtual void  callback(SoCallbackAction *action) ;
  virtual void  GLRender(SoGLRenderAction *action) ;
  virtual void search(SoSearchAction *action);


  /*----------------------------------------------------------------------------*/

 SoINTERNAL public:
  static void initClass() ;
  static void exitClass() ;

 protected:
  // Destructor
  virtual ~SoDataSetId() ;
} ;
/*----------------------------------------------------------------------------*/

#endif /* _SO_DATASET_ID_ */

