/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Jerome Hummel (Nov 2004)
**=======================================================================*/


#ifndef  _SO_WEIGHT_PROPERTY_
#define  _SO_WEIGHT_PROPERTY_

#include <Inventor/fields/SoSFFloat.h> 
#include <Inventor/nodes/SoNode.h> 



/**
 * @LDMEXT Priority property of a rendering node.
 * 
 * @ingroup LDMNodes
 * 
 * @DESCRIPTION
 * This node allows you to assign a priority to an LDM rendering node (e.g., SoOrthoslice, SoMeshSkin).
 * Each rendering node inserted after this node will have the priority
 * specified in the #priority field. The priority must be between 0 and 1 inclusive.
 * By default, VolumeViz assigns the same priority depending on the type of node:
 * (0.5 for SoVolumeRender nodes, 0.9 for all other geometry nodes).
 *
 * The SoGeometryPriority node lets you assign higher priority to specific geometry
 * nodes. For example to prioritize the loading of tiles around a Z axis ortho slice
 * against an X axis ortho slice.
 *
 * Higher resolution tiles for higher priority geometry are loaded before 
 * higher resolution tiles for lower priority geometry.
 *
 * @FILE_FORMAT_DEFAULT
 * GeometryPriority{
 *    @TABLE_FILE_FORMAT
 *    @TR weight            @TD 0.0
 *    @TABLE_END
 * }
 *
 * @ACTION_BEHAVIOR
 * SoCallbackAction,
 * SoGLRenderAction,
 * SoPickAction,
 * SoWriteAction,
 * SoGetBoundingBoxAction @BR
 * Sets geometry priority parameters in the traversal state.
 *
 * @SEE_ALSO
 *  SoDataSet
 *
 * 
 */
class LDM_API SoGeometryPriority : public SoNode {
  SO_NODE_HEADER( SoGeometryPriority );

 public:
   /** Constructor */
   SoGeometryPriority();

   /** Constructor that automatically initializes 
   * the #priority field to the specified value. 
   */
   SoGeometryPriority(float);

   /** 
   * Geometry priority between 0 and 1 inclusive.
   */
   SoSFFloat priority;

 SoINTERNAL public:
  static void initClass();
  static void exitClass();


 SoEXTENDER public:
  virtual void doAction( SoAction *action );
  virtual void GLRender( SoGLRenderAction *action );
  virtual void callback( SoCallbackAction *action );
  virtual void getBoundingBox(SoGetBoundingBoxAction *action);
  virtual void pick(SoPickAction *action) ;
  virtual void write(SoWriteAction *action);


protected:
  // Destructor
  virtual ~SoGeometryPriority();
};
//--------------------------------------------------------------------------------

#endif // _SO_WEIGHT_PROPERTY_


