/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef SO_MULTI_DATA_SEPARATOR_H
#define SO_MULTI_DATA_SEPARATOR_H

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

#include <LDM/SoLDMMediator.h>
#include <LDM/elements/SoDataSetElement.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/STL/set>

SO_PIMPL_PUBLIC_DECLARATION(SoMultiDataSeparator)

/**
* @LDMEXT Separator for combining multiple data sets
* @ingroup LDMNodes
*
* @DESCRIPTION
*
* The SoMultiDataSeparator node allows you to combine multiple data sets.
*
* This is the correct method for combining multiple data sets. Combining
* multiple data sets without inserting them under an SoMultiDataSeparator
* node may produce incorrect results and should be avoided.
*
* Each data set is represented by an SoDataSet node (typically an SoVolumeData node).  
* Combining is enabled by an SoDataCompositor node for CPU combining or
* an SoVolumeShader node for GPU combining.  A common use of GPU combining is to
* implement co-blending of multiple volumes, in other words using a fragment shader
* to combine the color and/or intensity values of the voxels.
*
* Some rules must be followed when doing render or data compositing:
*
*   - Each SoVolumeData node must have a unique #SoDataSet::dataSetId. @BR
*
*   - All the SoVolumeData nodes to be composited, as well as the compositing node
*     (e.g. SoVolumeShader for slices or SoVolumeRenderingQuality for volumes) and
*     the rendering node (e.g. SoVolumeRender), must be under an SoMultiDataSeparator node.
*
*   - The SoVolumeData nodes to be composited must be all scalar data sets or all RGBA data
*     sets.  To composite scalar and RGBA data sets under the same SoMultiDataSeparator,
*     set the @I usePalettedTexture@i field to false in the scalar dataset's
*     SoVolumeData node to force the scalar data to be converted into RGBA data.
*
*   - An SoVolumeData node used in a data compositing scheme must not be inserted multiple
*     times in the scene graph. Use another volume data node pointing to the same file.
*
*   - All transfer functions must have the same 'colorMapType' and must have the same number
*     of entries in the colormap.
*
* Each SoVolumeData node has its own resource settings (see field #SoDataSet::ldmResourceParameters).
* In the case of combining multi data, data with the same characteristics (volume size, tile size and same
* location in world coordinates) aggregate their resources to display the best resolution possible.
* For example with 4 datasets VD1, VD2, VD3, VD4 that have same resource parameters but not
* SoLMDRessourceParameters::max2DTexMemory:
*   - VD1: max2DTexMemory = 1GB
*   - VD2: max2DTexMemory = 1GB
*   - VD3: max2DTexMemory = 9GB
*   - VD4: max2DTexMemory = 1GB
* If VD1 and VD3 have the same characteristics and VD2 and VD4 have other identical characteristics, in
* this case VD1 and VD3 will share 10 GB of 2D texture memory while VD2 and VD4 will share 2 GB.
* The same rule applies for other ldm resource parameters.
*
* GPU combining must be implemented in a shader program written in the standard GLSL language.
* Use a SoVolumeShader node to specify the shader program.  The shader source code
* is loaded using (for example) a SoFragmentShader object. You can specify uniform parameters for
* the shader using the SoShaderParameter subclasses. See SoVolumeShader for
* more information about the shader function library provided by VolumeViz.
*
* It is possible to compose datasets that have different dimensions, tile sizes and transformations. @BR
* In order to help fetch the correct data values in custom shaders, the included @I@B VolumeViz/vvizStructure.h@b@i
* shader provides texture coordinate conversion functions. @BR
* See SoVolumeShader for more details.
*
* Each data set typically has a SoDataRange node and a SoTransferFunction
* node to define the mapping from data values to color values.
* For each SoVolumeData, a separate 3D texture is generated and sent to the GPU.
* You can generate 3D textures with different precisions (8-bit or 12-bit) according to
* the SoDataSet::texturePrecision field. The SoDataSet::dataSetId field determines
* the texture unit used for each data.
* All colormaps are aggregated into a single 2D texture.
*
* A custom fragment shader can retrieve the voxel's data value from each 3D texture 
* using the GLSL VolumeViz function:
* \code
*               VVIZ_DATATYPE value = VVizGetData( dataSetId, texCoord );
* \endcode
* A custom fragment shader can lookup the color/intensity for each data value from
* the appropriate colormap, using the GLSL VolumeViz function:
* \code
*               vec4 color = VVizTransferFunction( value, colorMapId );
* \endcode
* A custom fragment shader can then compute (using custom blending functions) the actual
* color for the voxel and output that color using the GLSL VolumeViz function:
* \code
*               VVizOutputColor( color ):
* \endcode
*
* @EXAMPLE
* The following code shows how to do multidata rendering using an
* SoVolumeShader node to combine values for an SoVolumeRender node.
* Given two SoVolumeData nodes ds1 and ds2:
*
* \if_cpp
* \code
*    SoVolumeShader* volumeShader = new SoVolumeShader();
*
*    SoVolumeData* volumeData1 = new SoVolumeData();
*    volumeData1->dataSetId  = 0;
*    SoDataRange* dataRange1 = new SoDataRange();
*    dataRange1->dataRangeId = 0;
*    SoTransferFunction* colorMap1 = new SoTransferFunction();
*
*    SoVolumeData* volumeData2 = new SoVolumeData();
*    volumeData2->dataSetId  = 1;
*    SoDataRange* dataRange2 = new SoDataRange();
*    dataRange2->dataRangeId = 1;
*    SoTransferFunction* colorMap2 = new SoTransferFunction();
*
*    SoVolumeRender* volumeRender = new SoVolumeRender();
*
*    SoMultiDataSeparator* multiDataSep = new SoMultiDataSeparator();
*      multiDataSep->addChild( volumeShader ); // Shader to combine volumes
*
*      multiDataSep->addChild( volumeData1 );
*      multiDataSep->addChild( dataRange1 );
*      multiDataSep->addChild( colorMap1 );
*
*      multiDataSep->addChild( volumeData2 );
*      multiDataSep->addChild( dataRange2 );
*      multiDataSep->addChild( colorMap2 );
*
*      multiDataSep->addChild( volumeRender );
*    root->addChild( multiDataSep );
* \endcode
* \endif
* \if_dotnet
* \code
*    SoVolumeShader volumeShader = new SoVolumeShader();
*
*    SoVolumeData volumeData1 = new SoVolumeData();
*    volumeData1.dataSetId.Value = 0;
*    SoDataRange dataRange1 = new SoDataRange();
*    dataRange1.dataRangeId.Value = 0;
*    SoTransferFunction colorMap1 = new SoTransferFunction();
*
*    SoVolumeData volumeData2 = new SoVolumeData();
*    volumeData2.dataSetId.Value = 1;
*    SoDataRange dataRange2 = new SoDataRange();
*    dataRange2.dataRangeId.Value = 1;
*    SoTransferFunction colorMap2 = new SoTransferFunction();
*
*    SoVolumeRender volumeRender = new SoVolumeRender();
*
*    SoMultiDataSeparator multiDataSep = new SoMultiDataSeparator();
*        multiDataSep.AddChild( volumeShader ); // Shader to combine volumes
*
*        multiDataSep.AddChild( volumeData1 );
*        multiDataSep.AddChild( dataRange1 );
*        multiDataSep.AddChild( colorMap1 );
*
*        multiDataSep.AddChild( volumeData2 );
*        multiDataSep.AddChild( dataRange2 );
*        multiDataSep.AddChild( colorMap2 );
*
*        multiDataSep.AddChild( volumeRender );
*    root.AddChild(multiDataSep);
* \endcode
* \endif
* \if_java
* \code
*    SoVolumeShader volumeShader = new SoVolumeShader();
*
*    SoVolumeData volumeData1 = new SoVolumeData();
*    volumeData1.dataSetId.setValue( 0 );
*    SoDataRange dataRange1 = new SoDataRange();
*    dataRange1.dataRangeId.setValue( 0 );
*    SoTransferFunction colorMap1 = new SoTransferFunction();
*
*    SoVolumeData volumeData2 = new SoVolumeData();
*    volumeData2.dataSetId.setValue( 1 );
*    SoDataRange dataRange2 = new SoDataRange();
*    dataRange2.dataRangeId.setValue( 1 );
*    SoTransferFunction colorMap2 = new SoTransferFunction();
*
*    SoVolumeRender volumeRender = new SoVolumeRender();
*
*    SoMultiDataSeparator multiDataSep = new SoMultiDataSeparator();
*        multiDataSep.addChild( volumeShader ); // Shader to combine volumes
*
*        multiDataSep.addChild( volumeData1 );
*        multiDataSep.addChild( dataRange1 );
*        multiDataSep.addChild( colorMap1 );
*
*        multiDataSep.addChild( volumeData2 );
*        multiDataSep.addChild( dataRange2 );
*        multiDataSep.addChild( colorMap2 );
*
*        multiDataSep.addChild( volumeRender );
*    root.addChild(multiDataSep);
* \endcode
* \endif
*
* @SEE_ALSO
* SoDataSet, SoVolumeData, SoDataCompositor, SoVolumeShader
*
*
*/
class LDM_API SoMultiDataSeparator : public SoSeparator {
  SO_NODE_HEADER(SoMultiDataSeparator);
  SO_PIMPL_PUBLIC_HEADER(SoMultiDataSeparator)

public:

 /**
  * Constructor.
  */
  SoMultiDataSeparator();

SoEXTENDER public:
  virtual void doAction(SoAction *action);
  virtual void write(SoWriteAction *action);

protected:
  virtual ~SoMultiDataSeparator();

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  /**Remove the given dataset*/
  void remove(SoDataSet* ds);

  /** Remove data set from LDM loading threads. */
  void removeFromLdm(SoDataSet* ds);

};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif


