/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _SO_BUFFER_ASYNC_INTERFACE_H_
#define _SO_BUFFER_ASYNC_INTERFACE_H_

#include <Inventor/SbBase.h>
#include <Inventor/devices/SoBufferObject.h>

class SoBufferAsyncNotifierInterface;

/**
* @LDMEXT LDM interface to optimize memory management of tiles .
*
* @ingroup LDMTiles
*
* @DESCRIPTION
* Specialized buffer object classes may implement this interface
* to provide additional information about the contents of the buffer.
*
* @SEE_ALSO
*    SoBufferObject
*    SoCpuBufferCompressed
*    SoCpuBufferUniform
*
* [OIV-WRAPPER-CLASS NO_WRAP]
*/
class LDM_API SoBufferAsyncInterface
{
public:

  /** Return TRUE if the data attached to this buffer are not currently available */
  virtual bool isInMemory() = 0;

  /** 
   * Ask to initiate an ansynchronous load of the data if not already in memory.
   *
   * Application must call asyncNotifier->refetchNotify()
   * In order to let LDM know that some new data are available. 
   */
  virtual void requestRefetch(SoBufferAsyncNotifierInterface* asyncNotifier, const double weight) = 0;

  /** Destructor. */
  virtual ~SoBufferAsyncInterface() {}
};

#endif //_SO_BUFFER_ASYNC_INTERFACE_H_


