/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _SO_BUFFER_ASYNC_NOTIFIER_INTERFACE_H_
#define _SO_BUFFER_ASYNC_NOTIFIER_INTERFACE_H_

#include <Inventor/SbBase.h>
#include <Inventor/misc/SoRefCounter.h>

/**
* @LDMEXT LDM interface to optimize memory management of tiles .
*
* @ingroup LDMTiles
*
* @DESCRIPTION
* Specialized buffer object classes may implement this interface
* to provide additional information about the contents of the buffer.
*
* @SEE_ALSO
*    SoBufferObject
*    SoCpuBufferCompressed
*    SoCpuBufferUniform
*
*/
class LDM_API SoBufferAsyncNotifierInterface : public SoRefCounter
{
public:

  /** Constructor **/
  SoBufferAsyncNotifierInterface() {}

  /**
   * Notify an object that a buffer implementing SoBufferAsyncInterface has change its state.
   * It allows for example to let LDM know that some new data are now available.
   *
   * @return TRUE if the notification is taken in account,
   * false otherwise (if the object to notify does not exist anymore for example)
   */
  virtual bool refetchNotify() = 0;

protected:
  /** Destructor. */
  virtual ~SoBufferAsyncNotifierInterface() {}

  // Protect access to asynchronous notifier
  SbThreadMutex m_asynchNotifierMtx;

};

#endif //_SO_BUFFER_ASYNC_NOTIFIER_INTERFACE_H_


