/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef _LDM_XML_TAG_
#define _LDM_XML_TAG_

class SbThreadMutex;
class SiBitFile;
class SoDataCompressor;
class SoDataCompressInfo;

#include <Inventor/SbBasic.h>

/**
 * @LDMEXT XML tag from LDM filer.
 *
 * @ingroup LDMReaders
 *
 * @DESCRIPTION
 *
 * This class allows the application to read back a custom XML section that was
 * inserted in a LDM file header using the method SoLDMConverter::setXmlCallback().
 *
 * Let's suppose the following XML text appears in the LDM file header:
 * \par
 * \verbatim
   ...
   <MY_CUSTOM_TAG_SECTION>
     text
     <CUSTOM_TAG1>value1</CUSTOM_TAG1>
     <CUSTOM_TAG2>value2</CUSTOM_TAG2>
   </MY_CUSTOM_TAG_SECTION>
   ...
   \endverbatim
 *
 * The following code will produce the output below:
 *
 * \if_cpp
 * \code
 *   SoVolumeData* volData = new SoVolumeData(); // Volume from LDM file
 *   . . .
 *   SoVRLdmFileReader* reader = (SoVRLdmFileReader*)(volData->getReader());
 *   SbXmlTag myTagSection = reader->getXmlTag( "MY_CUSTOM_TAG_SECTION" );
 *   if (myTagSection.exist()) {
 *     const char* sectionName = myTagSection.getName();
 *     const char* sectionText = myTagSection.getText();
 *     for (SbXmlTag t = myTagSection.getFirstChildTag(); t.exist(); t = t.getNextSiblingTag()) {
 *       const char* tagName = t.getName();
 *       const char* tagText = t.getText();
 *     }
 *   }
 * \endcode
 * \endif
 * \if_dotnet
 * \code
 *   SoVolumeData volData = new SoVolumeData(); // Volume from LDM file
 *   . . .
 *   SoVRLdmFileReader reader = (SoVRLdmFileReader)volData.Reader;
 *   SbXmlTag mySectionTag = reader.GetXmlTag("MY_CUSTOM_TAG_SECTION");
 *   if (mySectionTag.Exist())
 *   {
 *       string sectionName = mySectionTag.Name;
 *       string sectionText = mySectionTag.Text;
 *       for (SbXmlTag t = mySectionTag.FirstChildTag; t.Exist(); t = t.NextSiblingTag)
 *       {
 *           string tagName = t.Name;
 *           string tagText = t.Text;
 *       }
 *   }
 * \endcode
 * \endif
 * \if_java
 * \code
 *   SoVolumeData volData = new SoVolumeData(); // Volume from LDM file
 *   . . .
 *   SoVRLdmFileReader reader = (SoVRLdmFileReader)volData.getReader();
 *   SbXmlTag mySectionTag = reader.getXmlTag("MY_CUSTOM_TAG_SECTION");
 *   if (mySectionTag.exist())
 *   {
 *       String sectionName = mySectionTag.getName();
 *       String sectionText = mySectionTag.getText();
 *       for (SbXmlTag t = mySectionTag.getFirstChildTag(); t.exist(); t = t.getNextSiblingTag())
 *       {
 *           String tagName = t.getName();
 *           String tagText = t.getText();
 *       }
 *   }
 * \endcode
 * \endif
 *
 * Output:
 * \par
 * \verbatim
   MY_CUSTOM_TAG_SECTION:text
     CUSTOM_TAG1:value1
     CUSTOM_TAG2:value2
   \endverbatim
 *
 *
 */
class LDM_API SbXmlTag {
public:
  /**
   *  Indicates if this XML tag is valid.
   */
  bool         exist();

  /**
   *  Returns the name of the XML tag.
   */
  const char*  getName();

  /**
   *  Returns the text associated with the XML tag.
   */
  const char*  getText();

  /**
   *  Returns the first XML child tag.
   */
  SbXmlTag     getFirstChildTag();

  /**
   *  Returns the next sibling XML child.
   */
  SbXmlTag     getNextSiblingTag();

SoINTERNAL public:
  SbXmlTag(void* = NULL);

protected:
  void *m_tag;
};

#endif


