///////////////////////////////////////////////////////////////////////////////
//
// This class is part of the Open Inventor Medical utility library.
//
// The medical utility classes are provided as a prebuilt library named
// "fei_inventor_medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef ORTHO_SLICE_BORDER_H_
#define ORTHO_SLICE_BORDER_H_

#include <Medical/InventorMedical.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFColor.h>
#include <VolumeViz/nodes/SoOrthoSlice.h>

class SoDrawStyle;
class SoSeparator;

/**
 * @VSGEXT @PREVIEWTAG @OIVMETAG Ortho slice shape node with border.
 *
 * @ingroup MedicalNodes
 *
 * @DESCRIPTION
 *   This node is a subclass of SoOrthoSlice. It defines an ortho (axis aligned)
 *   slice along the X, Y, or Z axis of a volume defined by an SoVolumeData node.
 *
 *   See SoOrthoSlice for important details about slice rendering. Note that the
 *   SoOrthoSlice clipping feature does @I not@i affect rendering of the border.
 *
 *   The border color can be used, for example, to help the user see at a glance
 *   which axis each slice corresponds to. Another use is to change the border
 *   color when a slice is selected.
 *
 *   Create an SoOrthoSlice node in the 2D view.  Then create an OrthoSliceBorder
 *   node in the 3D view, set its renderSlice field to false and connect its
 *   sliceNumber field to the sliceNumber field of the SoOrthoSlice node to keep
 *   the slices in sync.
 *
 * @FILE_FORMAT_DEFAULT
 *    OrthoSliceBorder {
 *    @TABLE_FILE_FORMAT
 *       @TR dataSetId       @TD 0
 *       @TR sliceNumber     @TD 0
 *       @TR axis            @TD Z
 *       @TR interpolation   @TD LINEAR
 *       @TR alphaUse        @TD ALPHA_BINARY
 *       @TR useRGBA         @TD FALSE
 *       @TR clipping        @TD FALSE
 *       @TR clippingSide    @TD BACK
 *       @TR alternateRep    @TD NULL
 *       @TR enableBumpMapping @TD FALSE
 *       @TR bumpScale       @TD 1.0
 *       @TR enableBorder    @TD FALSE
 *       @TR borderColor     @TD 0.84 0.43 0.02
 *       @TR borderWidth     @TD 2.0
 *       @TR enableImage     @TD TRUE
 *    @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *    InventorMedical,
 *    SoOrthoSlice,
 *    SoObliqueSlice,
 *    ObliqueSliceBorder
 *
 * @PREVIEWFEATURES
 */

class SoDEPRECATED_CLASS_NOWARN( 101000, "No longer supported, use #SoOrthoSlice instead" ) INVENTORMEDICAL_API OrthoSliceBorder : public SoOrthoSlice
{
  SO_NODE_HEADER(OrthoSliceBorder);

 public:

  /** Initialize class (called automatically by InventorMedical::init()). */
  static void initClass();

  /** Finish using class (called automatically by InventorMedical::finish()). */
  static void exitClass();

  /** Constructor. */
  OrthoSliceBorder();

 protected:

  /** Destructor. */
  virtual ~OrthoSliceBorder();

  /** Called by SoGLRenderAction. */
  virtual void GLRender(SoGLRenderAction* action);

  SoRef<SoSeparator> m_scene;    // Internal scene graph
  SoRef<SoNode>      m_geometry; // Shape node that draws the border
  SbBox3f      m_volumeExtent;
  int          m_sliceAxis;
  int          m_sliceNumber;
  SoDrawStyle* m_style;
};

#endif //OrthoSliceBorder
