/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_CELLFACET_
#define  _PO_CELLFACET_

#include <MeshViz/3Ddata/PoCellShape.h>

/**
 * @DTEXT  Builds facets of a cell of a mesh.
 * 
 * @ingroup MeshRepresentation
 * 
 * @DESCRIPTION
 *    The cell is defined by its index in the current mesh (see PoCellShape).
 *    The current mesh is either the one defined by PoMesh::setMesh() or (if 
 *    this method is not called) the one defined in a special node inherited 
 *    during the traversal. This node has a type derived from PoMeshProperty.
 * @CATALOG_PARTS_INCLUDE pocellfacets.cat.html
 * 
 * 
 */
class MESHVIZ_API PoCellFacets : public PoCellShape {
  
  SO_KIT_HEADER(PoCellFacets) ;
  
  SO_KIT_CATALOG_ENTRY_HEADER(groupCellFacets) ;
  // Define fields for new parts


 public:

  /**
   * Constructor.
   */
  PoCellFacets() ;

  /**
   * Forces node-kit rebuilding. See PoBase.
   */
  virtual void   rebuild() ;

  /*----------------------------------------------------------------------------*/
 PoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  void drawFacets(const PbCell *cell);

 protected:
  virtual ~PoCellFacets() ;  
  // Destructor

  // Methods
  virtual void setDefaultOnNonWritingFields();
  virtual void addElementsAllCaches() ;
  virtual void preRebuild();

} ;

/*----------------------------------------------------------------------------*/

#endif /* _PO_CELLFACET_ */


