/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_MESHVIZ_
#define  _PO_MESHVIZ_

#define PoDataViz PoMeshViz

#include <SoVersion.h>
#include <MeshViz/PoMeshVizLibName.h>

#ifdef _WIN32
# ifndef MeshViz_EXPORTS
#  ifndef OIV_DISABLE_AUTOLINK
#   pragma comment(lib,__MESHVIZLIB)
#  endif
# endif
#endif

#include <MeshViz/PbBasic.h>

#include <Inventor/SoModule.h>
SO_MODULE_HEADER(MoMeshViz, __MESHVIZDLL)

/**
 * @DTEXT Class to initialize MeshViz.
 * 
 * @ingroup MeshViz
 * 
 * @DESCRIPTION
 *   This class allows the user to initialize the MeshViz module. The module
 *   must be initialized before using any other classes of the module.
 * 
 * @SEE_ALSO
 *    MeshViz Overview,
 *    PoBase
 * 
 * 
 */
class MESHVIZ_API PoMeshViz {

 public:

  /**
   * Initializes all nodekit classes of MeshViz by registering them
   * in the database. This function needs to be called before any 
   * other nodekit class of MeshViz may be constructed or accessed. 
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void init();

	/**
   * Finishes all nodekit classes of MeshViz by unregistering them
   * in the database. This function needs to be called after any 
   * other nodekit class of MeshViz may be destroyed.
   * [OIV-WRAPPER-NO-WRAP]
   */
	static void finish();

  /**
   * Returns TRUE if module is currently initialized.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static bool isInitialized();

  /**
   * Returns a character string identifying the name of the extension.
   */
  static const char *getProductName();

#if SoDEPRECATED_BEGIN(2023200)
  /**
   * Returns a character string identifying the version of the extension.
   */
  SoDEPRECATED_METHOD(2023.2, "This method should no longer be used. Use SoLicensesInfo::getVersion() method instead.")
  static const char *getVersion();
#endif /** @DEPRECATED_END */
private:
  static const char *s_versionString;
} ;
/*---------------------------------------------------------------------------*/

#endif /* _PO_MESHVIZ_ */

