/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Mar 1999)
**=======================================================================*/

                                                             /* include files */
#ifndef  _PO_LABEL_HINTS_ELEMENT_
#define  _PO_LABEL_HINTS_ELEMENT_


#include <Inventor/elements/SoReplacedElement.h>
#include <MeshViz/nodes/PoLabelHints.h>

/**
 * @ingroup MeshVizElements
 */
class MESHVIZ_API PoLabelHintsElement : public SoReplacedElement {
  
  SO_ELEMENT_HEADER(PoLabelHintsElement);
  
 public:
  // Set the current label hints.
  //
  // @UNICODE_WARNING
  SoNONUNICODE static void set(SoState *state, SoNode *node, 
                  PoLabelHints::LabelPath labelPath,
                  PoLabelHints::Justification justif,
                  const char *addString,
                  SbBool isAddStringIgnored,
                  SbBool isLabelLineVisible);


 // Set the current label hints.
  static void set(SoState *state, SoNode *node, 
                  PoLabelHints::LabelPath labelPath,
                  PoLabelHints::Justification justif,
                  const SbString& addString,
                  SbBool isAddStringIgnored,
                  SbBool isLabelLineVisible);
  
  /** Return the current label hints from the state.
   * [OIV-WRAPPER-ARG IN,OUT,OUT,OUT,OUT]
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE static void get(SoState *state, 
                  PoLabelHints::LabelPath &labelPath,
                  PoLabelHints::Justification &justif,
                  const char *&addString,
                  SbBool &isLabelLineVisible);
  
  /** Return the current label hints from the state.
   * [OIV-WRAPPER-ARG IN,OUT,OUT,OUT,OUT]
   */
  static void get(SoState *state, 
                  PoLabelHints::LabelPath &labelPath,
                  PoLabelHints::Justification &justif,
                  SbString& addString,
                  SbBool &isLabelLineVisible);

  /** Default values
   * [OIV-WRAPPER-ARG OUT,OUT,OUT,OUT]
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE static  void getDefault(PoLabelHints::LabelPath &labelPath,
                          PoLabelHints::Justification &justif,
                          char *&addString,
                          SbBool &isLabelLineVisible);
  
  /** Default values
   * [OIV-WRAPPER-ARG OUT,OUT,OUT,OUT]
   */
  static  void getDefault(PoLabelHints::LabelPath &labelPath,
                          PoLabelHints::Justification &justif,
                          SbString& addString,
                          SbBool &isLabelLineVisible);

 SoINTERNAL public:
  // Initializes the class
  static void initClass();
	static void exitClass() ;
  
 protected:
  virtual ~PoLabelHintsElement();

  /** @copydoc SoElement::init */
  virtual void init(SoState *state);

 private:
  PoLabelHints::LabelPath m_labelPath;
  PoLabelHints::Justification m_justif;
  SbString m_addString;
  SbBool m_isLabelLineVisible;
};
/*----------------------------------------------------------------------------*/

#endif // _PO_LABEL_HINTS_ELEMENT_


