/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Dec 1997)
**=======================================================================*/

                                                             /* include files */
#ifndef  _PO_NUMERIC_DISPLAY_FORMAT_ELEMENT_
#define  _PO_NUMERIC_DISPLAY_FORMAT_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>

class PbNumericDisplayFormat;

/**
 * @ingroup MeshVizElements
 */
class MESHVIZ_API PoNumericDisplayFormatElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(PoNumericDisplayFormatElement);
  
 public:  
  // set the current NumericDisplayFormat
  static void set(SoState *state, SoNode *node,
                  const PbNumericDisplayFormat *numericDisplayFormat);
  
  // return the current NumericDisplayFormat from the state
  static const PbNumericDisplayFormat *get(SoState *state);
  
 SoINTERNAL public:
  // Initializes the class
  static void initClass();
	static void exitClass() ;
  
 protected:
  static PbNumericDisplayFormat *m_defaultNumericDisplayFormat;
  PbNumericDisplayFormat *m_numericDisplayFormat;
  
  /** @copydoc SoElement::init */
  virtual void init(SoState *state);

  virtual ~PoNumericDisplayFormatElement();
};
/*----------------------------------------------------------------------------*/

#endif // _PO_NUMERIC_DISPLAY_FORMAT_ELEMENT_


