/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Mar 1996)
**=======================================================================*/


#ifndef  _PI_NUMERIC_FORMAT_
#define  _PI_NUMERIC_FORMAT_
/* include files */
#include <Inventor/SbLinear.h>
#include <MeshViz/PbBasic.h>
/* macro & constants */
#define  PDEFAULT_NUMERIC_FORMAT  "%d"
/* classes used  */
class PbNumericDisplayFormat ;

/*----------------------------------------------------------------------------*/

PoINTERNAL class MESHVIZ_API PiNumericFormat {

 public:
  // Constructor
  PiNumericFormat() ;

  // The format is an integer format
  void setFormatInteger(int tenPower) ;
  
  // The format is a floating-point format
  void setFormatFloatingPoint(int numDec, int tenPower) ;

  // The format is compute automatically relative to
  // a real domain and a step.
  void setFormatAuto(float minVal, float maxVal, float step, 
                     SbBool isRounded) ;

  // The format is set by a PbNumericDisplayFormat object and
  // by a list of values
  void setFormat(const PbNumericDisplayFormat *format, int numValues,
                 const float *values, SbBool isRounded = FALSE) ;

  // The format is set by a PbNumericDisplayFormat object and
  // by a the min and max of values
  void setFormat(const PbNumericDisplayFormat *format, float minVal,
                 float maxVal, float step, SbBool isRounded = FALSE) ;
                 
  // Return the ten power of the format
  int getTenPower() const 
    { return tenPowerFormat ; }
  
  // Return the number of decimal of the format
  int getNumDecimal() const
    { return numDecimalFormat ; }

  // Return if TRUE if the format is a floating
  // point format
  SbBool isFloatingPointFormat() const
    { return floatingPointFormat ; }

  // Return the string corresponding to a given value
  // according the format.
  void getString(float value, char *string) const ;
  
 private:
  void findBestFormatOfDomain(float firstVal, float lastVal, float step, 
                              SbBool isRounded) ;

  SbBool floatingPointFormat ;
  int    tenPowerFormat ;
  int    numDecimalFormat ;
  char   valueFormat[12] ;
} ;

/*----------------------------------------------------------------------------*/

#endif /* _PI_NUMERIC_FORMAT_ */

