/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_ARROW3_
#define  _PO_ARROW3_

#include <MeshViz/graph/PoGraphMaster.h>


#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoMFVec3f.h>


/**
 * @DTEXT  Class to build a 3D arrow.
 * 
 * @ingroup GraphMisc
 * 
 * @DESCRIPTION
 *    This node draws a 3D arrow. The arrow is defined by a 
 *    point list. The start pattern and the end pattern can be parameterized.
 *
 *    This node draws a @I single@i 3D arrow consisting of a polyline with
 *    optional arrowhead or rectangle at each end.  Therefore the minimum
 *    number of points is 2.  Additional points could be used to make, for
 *    example, a curved arrow.
 * 
 * @FILE_FORMAT_DEFAULT
 *    PoArrow3 {
 *    @TABLE_FILE_FORMAT
 *       @TR point @TD 0 0 0
 *       @TR startPatternType @TD NO_PATTERN
 *       @TR endPatternType @TD NO_PATTERN
 *       @TR patternWidth @TD 0.05
 *       @TR patternHeight @TD 0.03
 *    @TABLE_END
 *    }
 * 
 * @CATALOG_PARTS_INCLUDE poarrow3.cat.html
 * 
 * 
 */
class MESHVIZ_API PoArrow3 : public PoGraphMaster {
  
  SO_KIT_HEADER(PoArrow3) ;
  
  /* Define fields for new parts */
  SO_KIT_CATALOG_ENTRY_HEADER(bodySep) ;
  SO_KIT_CATALOG_ENTRY_HEADER(bodyApp) ;
  SO_KIT_CATALOG_ENTRY_HEADER(body)    ;

  SO_KIT_CATALOG_ENTRY_HEADER(startSep) ;
  SO_KIT_CATALOG_ENTRY_HEADER(startApp) ;
  SO_KIT_CATALOG_ENTRY_HEADER(start)    ;

  SO_KIT_CATALOG_ENTRY_HEADER(endSep) ;
  SO_KIT_CATALOG_ENTRY_HEADER(endApp) ;
  SO_KIT_CATALOG_ENTRY_HEADER(end)    ;


 public:

  /**
   *  Type of pattern at the arrow extremities.
   */
  enum PatternType {
    /**
     *  No pattern at the arrow extremity.
     */
    NO_PATTERN,        
    /**
     *  Direct triangle (pointing away from the polyline) at the arrow extremity.
     */
    DIRECT_TRIANGLE,   
    /**
     *  Indirect triangle (pointing toward the polyline) at the arrow extremity.
     */
    INDIRECT_TRIANGLE, 
    /**
     *  Rectangle at the arrow extremity.
     */
    RECTANGLE          
  } ;

  /* Fields */

  /**
   * Point list of the arrow.
   */
  SoMFVec3f point ;

  /**
   * Defines the start arrow pattern type.
   */
  SoSFEnum  startPatternType ;

  /**
   * Defines the end arrow pattern type.
   */
  SoSFEnum  endPatternType ;

  /**
   * Define the width of the start and end arrow pattern. It is
   * given in the normalized space [0-1]x[0-1]x([0-1]) defined by the 
   * current domain (cf PoBase description).
   */
  SoSFFloat patternWidth ;

  /**
   * Define the height of the start and end arrow pattern. It is
   * given in the normalized space [0-1]x[0-1]x([0-1]) defined by the 
   * current domain (cf PoBase description).
   */
  SoSFFloat patternHeight ;



  /* Methods */

  /**
   * Default constructor.
   */
  PoArrow3()
    { init(TRUE) ; }

  /**
   * Constructor.
   * [OIV-WRAPPER-ARG NO_WRAP{_point->Length},ARRAY,IN,IN,IN,IN]
   */
  PoArrow3(int numPoints, const SbVec3f *_point, PatternType startType = NO_PATTERN,
           PatternType endType = NO_PATTERN, float _patternWidth = 0.05f, 
           float _patternHeight = 0.03f)
    { init(FALSE, numPoints, _point, startType, endType, _patternWidth, _patternHeight) ; } 

  /**
   * Forces node-kit rebuilding. See PoBase.
   */
  virtual void rebuild() ;

  /*----------------------------------------------------------------------------*/


 PoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 protected:
  // Methods
  // Destructor
  virtual ~PoArrow3() ;
  virtual void   setDefaultOnNonWritingFields() ;
  virtual SbBool setUpConnections(SbBool onOff, SbBool doItAlways = FALSE) ;

 private:
  // Init method
  void init(SbBool isDefault, int numPoints = 0, const SbVec3f *_point = NULL, 
            PatternType startType = NO_PATTERN,  PatternType endType = NO_PATTERN, 
            float _patternWidth = 0.05f, float _patternHeight = 0.03f) ;
  
  // Sensors
  FieldSensorList fieldSensorList ;
  
  // List of fields defined in this class
  SoFieldList     fieldList ;

} ;

/*----------------------------------------------------------------------------*/

#endif /*  _PO_ARROW3_ */

